import time

from django.core.management import BaseCommand
from datetime import datetime
from sacco.models import MemberAccount, AccountBroker
from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        business_id = [3, 4]
        branch_id = [3, 4]

        the_date = '2025/31/07'
        date_format = "%Y/%d/%m"
        the_date = datetime.strptime(the_date, date_format).date()

        for branch in branch_id:
            if branch == 3:
                cr_acc = 121
            else:
                cr_acc = 11329
                
            
            all_trans = Transactions.objects.filter(
                branch_id=branch,
                narration='Monthly Ledger fee payment for July',
                account_cr_id=cr_acc,
                tx_date=the_date,
            )
            print('all_trans', all_trans.count())

            time.sleep(12)

            for trans in all_trans:
                print(trans.narration)
                Transactions.objects.filter(id=trans.id).delete()
            print('---- DONE -------')



