from datetime import datetime

from django.core.management import BaseCommand
import pandas as pd
from django.db.models import Sum, Q

from loans.models import Loans
from sacco.models import MemberAccount, Member, AccountBroker
from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        the_branch = 27
        start_date_string = '2020/01/01'
        end_date_string = '2020/31/12'
        date_format = "%Y/%d/%m"
        start_date = datetime.strptime(start_date_string, date_format).date()
        end_date = datetime.strptime(end_date_string, date_format).date()

        all_loans = Loans.objects.filter(branch_id=the_branch, approved_on__lte=end_date)
        print(all_loans.count())
        for ln in all_loans:
            Transactions.objects.filter(branch_id=the_branch, loan=ln).delete()
            Loans.objects.filter(id=ln.id).delete()