import time

from django.core.management import BaseCommand

from sacco.models import TransactionCharge, AccountTypes
from transactions.models import Account, AccountCategory


class Command(BaseCommand):
    def handle(self, *args, **options):
        old_branch_id=3
        old_business_id=3
        new_branch_id=4
        new_business_id=4
        all_trans_charge = TransactionCharge.objects.filter(account_type__business_id=old_business_id)
        for charge in all_trans_charge:
            # get the similar acc type
            the_acc_type=AccountTypes.objects.filter(name=charge.account_type.name, business_id=new_business_id)
            if the_acc_type.exists():
                TransactionCharge.objects.create(
                    start=charge.start,
                    end = charge.end,
                    charge = charge.charge,
                    account_type=the_acc_type.first(),
                    charge_type=charge.charge_type,
                    status=charge.status,
                    is_charge_percentage=charge.is_charge_percentage,
                )

