import time

from django.core.management import BaseCommand

from transactions.models import Account, AccountCategory


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_acc = Account.objects.filter(business=3, member=None, added_by__isnull=False, eul__isnull=True,related_to__isnull=True)
        for acc in all_acc:
            print(acc.name)

            # check is the acc is not available
            check_acc = Account.objects.filter(business=4, member=None, added_by__isnull=False, name=acc.name.strip())
            if acc.name.strip() != '':
                print(f'Display:{acc.display_name}, Member:{acc.member}')
            if not check_acc and acc.name.strip() != '':

                if acc.eul is None and acc.related_to is None:
                    time.sleep(3)
                    Account.objects.create(
                        name=acc.name.strip(),
                        display_name=acc.display_name,
                        category=AccountCategory.objects.get(name=acc.category.name, business=4),
                        business_id=4,
                        added_by=acc.added_by
                    )
                    print('--- ADDED ----')
                else:

                    print('#### FAILED ####')
            else:
                print('#### FAILED ####')