import time

from django.core.management import BaseCommand

from loans.models import Loans, LoanTypes, GeneralCharge, ApplicationAccountOrLoanType
from sacco.models import AccountBroker, AccountTypes
from transactions.models import Account, AccountCategory, Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        # AccountBroker.objects.filter(members__branch_id=4).update(business_id=4)

        # #move change also the accounts
        # all_loans = Loans.objects.filter(branch_id=4)
        # for ln in all_loans:
        #     # update the loan types
        #     new_ln_type = LoanTypes.objects.get(name=ln.loan_type.name, business_id=4)
        #     Loans.objects.filter(id=ln.id).update(loan_type=new_ln_type)
        #     # Get all transctions
        #     all_trans = Transactions.objects.filter(loan=ln)
        #     for trans in all_trans:
        #         print('TRANS', trans.account_dr, trans.account_cr)
        #         if trans.account_dr is not None and trans.account_dr.business.id != 4 and trans.account_dr.member is None:
        #             new_dr_acc = Account.objects.get(name=trans.account_dr.name, business_id=4)
        #             Transactions.objects.filter(id=trans.id).update(account_dr=new_dr_acc)
        #         if trans.account_cr is not None and trans.account_cr.business.id != 4 and trans.account_cr.member is None:
        #             new_cr_acc = Account.objects.get(name=trans.account_cr.name, business_id=4)
        #             Transactions.objects.filter(id=trans.id).update(account_cr=new_cr_acc)

        # correct account
        all_gen_charges = GeneralCharge.objects.filter(business_id=4)
        for gen in all_gen_charges:
            # get the ApplicationAccountOrLoanType
            all_apps = ApplicationAccountOrLoanType.objects.filter(general_charge=gen)
            if all_apps.exists():
                print('ApplicationAccountOrLoanType already exists')
                for ap in all_apps:
                    if ap.account_type is not None:
                        if ap.account_type.business_id != 4 :
                            new_acc_ty = AccountTypes.objects.get(name=ap.account_type.name, business_id=4)
                            ApplicationAccountOrLoanType.objects.filter(id=ap.id).update(
                                account_type=new_acc_ty
                            )
                    if ap.loan_type is not None:
                        if ap.loan_type.business_id != 4 :
                            new_ln_ty = LoanTypes.objects.get(name=ap.loan_type.name, business_id=4)
                            ApplicationAccountOrLoanType.objects.filter(id=ap.id).update(
                                loan_type=new_ln_ty
                            )
            else:
                all_apps = ApplicationAccountOrLoanType.objects.filter(general_charge__charge=gen.charge, general_charge__business_id=3)
                print('ApplicationAccountOrLoanType --- MISSING ---')
                for ap in all_apps:
                    new_acc_ty = None
                    new_ln_ty = None
                    if ap.account_type is not None:
                        new_acc_ty = AccountTypes.objects.get(name=ap.account_type.name, business_id=4)
                    if ap.loan_type is not None:
                        new_ln_ty = LoanTypes.objects.get(name=ap.loan_type.name, business_id=4)
                    ApplicationAccountOrLoanType.objects.create(general_charge=gen,
                                                                account_type=new_acc_ty,
                                                                loan_type=new_ln_ty)
