import time

from django.core.management import BaseCommand
from datetime import datetime
import json

from loans.models import GeneralCharge
from sacco.models import AccountBroker, AutomatedCharge
from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        business_id = 3
        branch_id = 3
        # get the charge
        the_charge = GeneralCharge.objects.filter(charge='Monthly Ledger fee', business_id=business_id)
        the_charge = the_charge.first()
        #get all members
        mem_acc_numbers = [
            '301003502',
            '201004198',
            '201004285',
            '201004029',
            '201004130',
            '201004129',
            '201004172'
        ]
        all_mem_brokers = AccountBroker.objects.filter(business_id=business_id, the_account__acc_number__in=mem_acc_numbers)
        for the_mem in all_mem_brokers:
            print(the_mem.members.biodata.name)

        # sleep for 30 seconds
        time.sleep(30)
        # loop
        
        # If date has passed
        the_date = '2024/30/09'
        date_format = "%Y/%d/%m"
        the_date = datetime.strptime(the_date, date_format).date()
        # the_date = datetime.now().date()

        # get the Month
        month_name = the_date.strftime('%B')

        
        # loop
        all_trans_added = []
        for mem in all_mem_brokers:
            print(mem.the_account.account_type.name)
            # get the actual transactions account
            member_acc = Account.objects.filter(member=mem.the_account).first()
            # -- record the transaction
            charge_trans = Transactions.objects.create(
                branch_id=branch_id,
                transaction_type='Automated charge',
                account_dr=member_acc,
                account_cr_id=121,
                narration=f'Monthly Ledger fee payment for {month_name}',
                reporting_amount=the_charge.amount,
                # tx_date=datetime.now().date(),
                tx_date=the_date,
                receipt=datetime.now().strftime("%y%m%d%H%M%S"),
            )
            all_trans_added.append(charge_trans.id)
            # ---- debit the mem-acc
        AutomatedCharge.objects.create(
            added_transactions=json.dumps({
                'success_transactions': all_trans_added
            })
        )

