from datetime import datetime

from django.core.management import BaseCommand
from django.db.models import Q

from sacco.models import MemberAccount, AccountBroker, FinancialYear
from transactions.models import Account, Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        accounts = AccountBroker.objects.filter(members__branch_id__in=[3, 4],
                                                members__is_active=True,
                                                the_account__is_active = True,
                                                )
        for account in accounts:
            last_transaction = Transactions.objects.filter(
                Q(account_dr=Account.objects.get(member=account.the_account))
                | Q(account_cr=Account.objects.get(member=account.the_account))
            ).order_by('-tx_date').first()
            if last_transaction.tx_date < datetime.now().date():
                delta = datetime.now().date() - last_transaction.tx_date
                if delta.days > 365:
                    account.the_account.is_active = False
                    account.the_account.save()
            else:
                print('no transaction on this account')


