from datetime import datetime

from django.core.management import BaseCommand
from sacco.models import MemberAccount, AccountBroker, FinancialYear
from transactions.models import Account, Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        fin_year = FinancialYear.objects.get(name='2022-2023', business=30)
        date_string = '2023/01/01'
        date_format = "%Y/%d/%m"
        the_date = datetime.strptime(date_string, date_format).date()
        #get all accounts


        all_mem_acc = AccountBroker.objects.filter(business=30)

        for acc_br in all_mem_acc:
            mem_acc = acc_br.the_account
            # mem_acc
            this_account = MemberAccount.objects.get(id=mem_acc.id)
            member_acc = Account.objects.filter(member=this_account).first()

            #cash acc
            cash_acc = Account.objects.get(id=20163, business_id=30)

            Transactions.objects.create(
                branch_id=31,
                transaction_type='Deposit',
                account_dr=cash_acc,
                account_cr=member_acc,
                narration='Initial deposit for account openning',
                reporting_amount=50000,
                added_by_id=149,
                financial_year=fin_year,
                tx_date=the_date,
                # receipt=rec_no,
                # reference=ref_no
            )

            # transfer the money to registration fee
            Transactions.objects.create(
                branch_id=31,
                transaction_type='Registration',
                account_dr=member_acc,
                account_cr_id=20188,
                narration='Registration fee',
                reporting_amount=50000,
                added_by_id=149,
                financial_year=fin_year,
                tx_date=the_date,
                # receipt=rec_no,
                # reference=ref_no
            )


