from datetime import datetime

from django.core.management import BaseCommand
import pandas as pd
from django.db.models import Sum, Q

from loans.models import Loans
from sacco.models import MemberAccount, Member, AccountBroker
from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        the_branch = 27
        start_date_string = '2020/01/01'
        end_date_string = '2020/31/12'
        date_format = "%Y/%d/%m"
        start_date = datetime.strptime(start_date_string, date_format).date()
        end_date = datetime.strptime(end_date_string, date_format).date()

        # all_loans = Loans.objects.filter(branch=the_branch, approved_on__lte=end_date)
        df = pd.read_excel("kakumba_data.xlsx", sheet_name="Sheet1")
        data_list = df.to_dict(orient="records")
        # print(data_list)
        loans_data = []

        for acc in data_list:
            acc_broker = AccountBroker.objects.filter(the_account__acc_number=acc['acc'].strip(), business_id=26).first()
            the_acc = acc_broker.the_account
            the_member = Member.objects.filter(accounts__in =[the_acc]).first()
            print(the_member.biodata.name)
            the_loan = Loans.objects.filter(account=the_acc, approved_on__lte=end_date).first()
            account = Account.objects.filter(
                name="Loan Receivables", business_id=26
            ).first()
            principal_given = Transactions.objects.filter(
                Q(loan=the_loan, account_dr=account)).aggregate(total_debit=Sum("reporting_amount"))['total_debit']
            principal_paid = Transactions.objects.filter(tx_date__lte=end_date, loan=the_loan, transaction_type='Loan repayment').aggregate(total_debit=Sum("reporting_amount"))['total_debit']
            print('principal_paid', principal_paid)
            interest_paid = Transactions.objects.filter(tx_date__lte=end_date, loan=the_loan,
                                                         transaction_type='Loan interest').aggregate(
                total_debit=Sum("reporting_amount"))['total_debit']
            fines_paid = Transactions.objects.filter(tx_date__lte=end_date, loan=the_loan,
                                                        transaction_type='Loan Fines').aggregate(
                total_debit=Sum("reporting_amount"))['total_debit']
            if fines_paid is None:
                fines_paid = 0
            if interest_paid is None:
                interest_paid =0
            if principal_paid is None:
                principal_paid = 0
            loans_data.append({
                'name': the_member.biodata.name,
                'account': acc['acc'],
                'principal given': principal_given,
                'principal paid': principal_paid,
                'interest paid': interest_paid,
                'fines paid': fines_paid,
                'total payments': principal_paid+interest_paid+fines_paid
            })

        # df = pd.DataFrame(loans_data)

        # Specify the file path where you want to save the Excel file
        excel_file_path = "final_loan_balances.xlsx"

        # Export the DataFrame to an Excel file
        # df.to_excel(excel_file_path, index=False)




