from django.core.management import BaseCommand
from datetime import datetime, date

from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        date_string = "2023-07-21"
        date_format = "%Y-%m-%d"
        the_date = datetime.strptime(date_string, date_format)

        start_date = date(2023, 7, 21)
        end_date = date(2023, 7, 23)

        all_transctions = Transactions.objects.filter(
            branch_id=25,
            date_added__range = (start_date, end_date)
        )

        for trans in all_transctions:
            print(f'TRANS id:{str(trans.id)}, amt:{str(trans.reporting_amount)}, narration:{trans.narration}')
