from django.core.management import BaseCommand
from datetime import datetime
from django.utils.timezone import make_aware
from sacco.models import Member, AccountBroker
import pandas as pd

class Command(BaseCommand):
    def handle(self, *args, **options):
        cutoff_dt = make_aware(datetime(2023, 12, 31))
        updates = []
        all_members = Member.objects.filter(date_joined__isnull=True).select_related('biodata')

        for member in all_members:
            created = getattr(member, 'created_date', None)
            if not created:
                continue

            # Convert date to datetime at midnight
            if isinstance(created, datetime):
                created_dt = created
            else:
                created_dt = make_aware(datetime(
                    created.year, created.month, created.day
                ))

            member.date_joined = cutoff_dt if created_dt <= cutoff_dt else created_dt
            updates.append(member)
        Member.objects.bulk_update(updates, ['date_joined'])