from django.core.management import BaseCommand
from datetime import datetime
import pandas as pd
from django.db.models import Sum

from sacco.models import Member
from transactions.models import SharesTransactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 6
        from_date = '2021/01/01'
        end_date = '2021/31/12'

        date_format = "%Y/%d/%m"
        from_date = datetime.strptime(from_date, date_format).date()
        end_date = datetime.strptime(end_date, date_format).date()

        all_shares = []
        all_members = Member.objects.filter(branch=27)
        for mem in all_members:
            total_bought = SharesTransactions.objects.filter(buyer=mem, date__lte=end_date).aggregate(Sum('shares'))
            print('total_bought', total_bought)
            total_sold = SharesTransactions.objects.filter(seller=mem, date__lte=end_date).aggregate(Sum('shares'))
            if total_bought['shares__sum'] is None:
                total_bought = 0
            else:
                total_bought = total_bought['shares__sum']
            if total_sold['shares__sum'] is None:
                total_sold = 0
            else:
                total_sold = total_sold['shares__sum']

            the_data = {
                "Names": mem.biodata.name,
                "Account number": mem.accounts.first().acc_number,
                "total shares": total_bought-total_sold
            }
            all_shares.append(the_data)

        all_loans_df = pd.DataFrame.from_records(all_shares)
        # print(all_loans_df)
        all_loans_df.to_excel('shares2021.xlsx', index=False)