import json

from django.core.management import BaseCommand

from accounts.models import Permissions


class Command(BaseCommand):
    def handle(self, *args, **options):
        with open("sacco/fixtures/perms.json") as f:
            data = json.load(f)
            for x in data:
                if not Permissions.objects.filter(
                    description=x["fields"]["description"]
                ).exists():
                    Permissions.objects.create(
                        description=x["fields"]["description"],
                        item_name=x["fields"]["item_name"],
                    )
                self.stdout.write(self.style.SUCCESS("Successfully Created"))
