from django.core.management import BaseCommand
from datetime import datetime
from django.utils.timezone import now
import json
import time

from loans.models import GeneralCharge
from sacco.models import AccountBroker, AutomatedCharge
from transactions.models import Transactions, Account


class Command(BaseCommand):
    def handle(self, *args, **options):
        business_id = [3, 4]
        branch_id = [3,4]
        # get the charge
        the_charge = GeneralCharge.objects.filter(charge='Monthly Ledger fee', business_id=3)
        the_charge = the_charge.first()
        # get all members
        voluntary_account_id = 7
        today = now().date()
        all_mem_brokers = AccountBroker.objects.filter(business_id__in=business_id, members__is_active=True,
                                                       the_account__account_type_id__in=[7, 12]).exclude(
            created_date=today
        )
        print('MEM:', all_mem_brokers.count())

        # If date has passed
        the_date = '2024/31/12'
        date_format = "%Y/%d/%m"
        the_date = datetime.strptime(the_date, date_format).date()
        # the_date = datetime.now().date()

        # get the Month
        month_name = the_date.strftime('%B')

        print('month', month_name)
        time.sleep(10)

        # loop
        all_trans_added = []
        for mem in all_mem_brokers:
            print(mem.the_account.account_type.name)
            # get the actual transactions account
            member_acc = Account.objects.filter(member=mem.the_account).first()
            # -- record the transaction
            charge_trans = Transactions.objects.create(
                branch_id=3,
                transaction_type='Automated charge',
                account_dr=member_acc,
                account_cr_id=121,
                narration=f'Monthly Ledger fee payment for {month_name}',
                reporting_amount=the_charge.amount,
                # tx_date=datetime.now().date(),
                tx_date=the_date,
                receipt=datetime.now().strftime("%y%m%d%H%M%S"),
            )
            all_trans_added.append(charge_trans.id)
            # ---- debit the mem-acc
        AutomatedCharge.objects.create(
            added_transactions=json.dumps({
                'success_transactions': all_trans_added
            })
