from django.core.management import BaseCommand
import pandas as pd

from accounts.models import Position, Role
from loans.models import GeneralCharge, LoanTypes, ApplicationAccountOrLoanType
from sacco.models import AccountTypes, LoanSettings, FinancialYear, BusinessShares, OtherSettings, Member, GroupMember, \
    AccountBroker
from sacco.utils import migrate_single_member


class Command(BaseCommand):
    def handle(self, *args, **options):
        old_branch_id =3
        new_branch_id = 2
        old_business_id = 3
        new_business_id = 2

        # get all positions - add
        all_positions = Position.objects.filter(business_id=old_business_id)
        for pos in all_positions:
            new_pos = Position.objects.create(
                title=pos.title,
                business_id = new_business_id,
                # permissions = models.ManyToManyField(Permissions, blank=True)
            )
            new_pos.permissions.set(pos.permissions.all())
            new_pos.save()

        # get all roles - add
        all_role = Role.objects.filter(business_id=old_business_id)
        for role in all_role:
            new_role = Role.objects.create(
                title=role.title,
                business_id=new_business_id
            )

        # get all savings products
        all_acc_types = AccountTypes.objects.filter(business_id=old_business_id)
        for acc in all_acc_types:
            AccountTypes.objects.create(
                name=acc.name,
                is_fixed = acc.is_fixed,
                min_balance = acc.min_balance,
                maturity = acc.maturity,
                dormancy_period = acc.dormancy_period,
                deposit_charge = acc.deposit_charge,
                withdraw_charge = acc.withdraw_charge,
                transfer_charge = acc.transfer_charge,
                business_id = new_business_id,
                status = acc.status,
                deposit_charge_vary = acc.deposit_charge_vary,
                withdraw_charge_vary = acc.withdraw_charge_vary,
                transfer_charge_vary = acc.transfer_charge_vary,
                synced = acc.synced
            )

        # get all loan products - add
        all_loan_types = LoanTypes.objects.filter(business_id=old_business_id)
        for l_type in all_loan_types:
            new_loan_type = LoanTypes.objects.create(
                name=l_type.name,
                max_loan = l_type.max_loan,
                interest_rate = l_type.interest_rate,
                excuse_d = l_type.excuse_d,
                warning_d = l_type.warning_d,
                formula = l_type.formula,
                maximum_period = l_type.maximum_period,
                maximum_securities = l_type.maximum_securities,
                security_ratio = l_type.security_ratio,
                is_active = l_type.is_active,
                sub_intervals = l_type.sub_intervals,
                business_id =new_business_id,
                interval = l_type.interval,
                synced = l_type.synced,
                is_standalone = l_type.is_standalone,
            )


        # get all loan settings - update
        loan_settings_old = LoanSettings.objects.get(
            business_id=old_business_id
        )
        loan_settings_old = LoanSettings.objects.filter(
            business_id=new_business_id
        ).update(
            minimum_guarantors = loan_settings_old.minimum_guarantors,
            decimals = loan_settings_old.decimals,
            top_up_limit = loan_settings_old.top_up_limit,
            min_approvals = loan_settings_old.min_approvals,
            allow_others = loan_settings_old.allow_others,
            upload_minutes = loan_settings_old.upload_minutes,
            loan_topup = loan_settings_old.loan_topup,
            fines_on = loan_settings_old.fines_on,
            use_shares = loan_settings_old.use_shares,
            use_public_holidays = loan_settings_old.use_public_holidays,
        )

        # get all financial years - add
        all_financial_years = FinancialYear.objects.filter(business_id=old_business_id)
        for fy in all_financial_years:
            FinancialYear.objects.create(
                name=fy.name,
                start_date = fy.start_date,
                end_date = fy.end_date,
                business_id = new_business_id,
                status = fy.status
            )

        # get all general charges - add
        all_general_charges = GeneralCharge.objects.filter(business_id=old_business_id)
        for charge in all_general_charges:
            new_charge = GeneralCharge.objects.create(
                charge=charge.charge,
                application = charge.application,
                amount = charge.amount,
                is_percentage = charge.is_percentage,
                is_fine = charge.is_fine,
                status = charge.status,
                business_id = new_business_id,
                execution_period = charge.execution_period,
                execution_period_number = charge.execution_period_number,
                is_revenue = charge.is_revenue,
            )

            # get the applications and add them
            all_applications = ApplicationAccountOrLoanType.objects.filter(general_charge=charge)
            for appl in all_applications:
                ApplicationAccountOrLoanType.objects.create(
                    general_charge=appl.general_charge,
                    account_type = appl.account_type,
                    loan_type = appl.loan_type,
                )

        # get all share transactions
        # business_shares = BusinessShares.objects.get(business=old_business_id)
        # BusinessShares.objects.filter(business=new_business_id).update(
        #     # market_cap=models.FloatField(default=0)
        #     # sold = models.FloatField(default=0)
        #     business = models.ForeignKey('accounts.Business', on_delete=models.CASCADE)
        #     business_no = models.CharField(max_length=8, blank=True, null=True)
        # )
        business_setting = OtherSettings.objects.get(business_id=old_business_id)
        OtherSettings.objects.filter(business=new_business_id).update(
            dividends_sharing = business_setting.dividends_sharing,
            set_ordinary = business_setting.set_ordinary,
            share_price = business_setting.share_price,
            share_limit =business_setting.share_limit,
        )

        # get share settings - leave totals shares to 0

        # MOVE GROUPS FIRST
        group_data = pd.read_excel('sacco/fixtures/group_data.xlsx')
        groups_data = group_data.where(pd.notna(group_data), None).to_dict('records')
        failed_groups = []

        for grp in groups_data:
            the_group = Member.objects.filter(is_group=True, name=grp['group'])
            if the_group.exists():
                # get all its members and update their data
                all_members = GroupMember.objects.filter(group=the_group.first())
                for mem in all_members:
                    acc_broker = AccountBroker.objects.filter(members=mem.member).first()
                    migrate_single_member(acc_broker, new_branch_id, new_business_id, old_business_id)
            else:
                failed_groups.append({
                    'name': grp['group'],
                })

        # MOVE MEMBERS
        members_data = pd.read_excel('sacco/fixtures/members_data.xlsx')
        members_data = members_data.where(pd.notna(members_data), None).to_dict('records')
        failed_members = []

        for member in members_data:
            if member['acc_number'] is not None:
                the_acc_broker = AccountBroker.objects.filter(the_account__acc_number=str(member['acc_number']).strip())
                if the_acc_broker.exists():
                    # get all its members and update their data
                    acc_broker = the_acc_broker.first()
                    migrate_single_member(acc_broker, new_branch_id, new_business_id, old_business_id)

                else:
                    failed_members.append({
                        'name': member['name'],
                        'acc no': member['acc_number'],
                    })

        all_loans_df = pd.DataFrame.from_records(failed_members)
        all_loans_df.to_excel('FAILED_MEMBERS.xlsx', index=False)

        all_loans_df = pd.DataFrame.from_records(failed_groups)
        all_loans_df.to_excel('FAILED_GROUPS.xlsx', index=False)


