from django.core.management import BaseCommand
from django.db.models import Sum, FloatField
from django.db.models.functions import Coalesce

from sacco.models import AccountBroker
from transactions.models import Transactions, Account, AccountCategory
import json
import datetime
import pandas as pd

class Command(BaseCommand):
    def handle(self, *args, **options):
        biz_savings = AccountBroker.objects.filter(members__branch_id=25, members__is_active=True)
        accounts = []
        for member in biz_savings:
            branch_trans = Transactions.objects.filter(branch_id=25)

            debits = branch_trans.filter(account_dr__member=member.the_account
                                         ).values('account_dr').aggregate(
                debits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['debits']
            credits_ = branch_trans.filter(account_cr__member=member.the_account
                                           ).values('account_cr').aggregate(
                credits=Coalesce(Sum('reporting_amount'), 0.0, output_field=FloatField()))['credits']

            accounts.append(
                {
                    'Name': member.members.biodata.name,
                    'Account Number': member.the_account.acc_number,
                    'Saving Product': member.the_account.account_type.name,
                    'Balance': (credits_ if not None else 0) - (debits if not None else 0)
                }
            )

        df = pd.DataFrame(accounts)

        excel_file_path = "savings_balances.xlsx"
        df.to_excel(excel_file_path, index=False)


