from django.core.management import BaseCommand
from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions
import json


class Command(BaseCommand):
    def handle(self, *args, **options):
        acc_id = 14999
        #get all loans for
        all_loans = list(Loans.objects.filter(account_id=acc_id).values())
        # print('LOANS', all_loans[0])

        loan_ids =[]
        for ln in all_loans:
            # requested_on
            ln["requested_on"] = ln["requested_on"].isoformat()
            # approved_on
            ln["approved_on"] = ln["approved_on"].isoformat()
            # schedule_start
            ln["schedule_start"] = ln["schedule_start"].isoformat()
            # created_date
            ln["created_date"] = ln["created_date"].isoformat()

            loan_ids.append(ln['id'])


        old_data = []
        all_transacts = list(Transactions.objects.filter(loan_id__in =loan_ids).values())
        # print('TRANSACTION', all_transacts[0])

        for trans in all_transacts:
            # tx_date
            trans["tx_date"] = trans["tx_date"].isoformat()
            # date_added
            trans["date_added"] = trans["date_added"].isoformat()

        data = {
            'loans':all_loans,
            'transactions':all_transacts
        }

        file_path = "data.json"
        json_data = json.dumps(data, indent=4)
        with open(file_path, "w") as json_file:
            json_file.write(json_data)
