from django.core.management import BaseCommand
from loans.models import Loans, LoanFines
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions, Account, AccountCategory
import json
import datetime


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 27
        business_id = 26

        fine_receivables_acc = Account.objects.filter(name='fine receivables',
                                                      business_id=business_id)
        if fine_receivables_acc.exists():
            fine_receivables_acc = fine_receivables_acc.first()
        else:
            fine_receivables_acc = Account.objects.create(
                name='fine receivables', business_id=business_id,
                display_name='fine receivables',
                category=AccountCategory.objects.filter(name='Account Receivables',
                                                        business_id=business_id).first(),
            )

        finesaccount = Account.objects.filter(name='Loan Fines', business_id=business_id)
        if finesaccount.exists():
            finesaccount = finesaccount.first()
        else:
            finescat = AccountCategory.objects.filter(name='Loan incomes', business_id=business_id).first()
            finesaccount = Account.objects.create(name='Loan Fines', business_id=business_id,
                                                  category_id=finescat.id,
                                                  # added_by_id=userdata(request)
                                                  )

        all_fines = LoanFines.objects.filter(loan__branch_id =branch_id )
        #delete transactions
        Transactions.objects.filter(
            transaction_type='Fines',
            branch_id=branch_id
        ).delete()
        for ln in all_fines:
            fines_transaction = Transactions.objects.create(reporting_amount=ln.amount,
                                                            narration=f'Loan fine of {ln.amount}',
                                                            account_dr=fine_receivables_acc,
                                                            account_cr_id=finesaccount.id, loan=ln.loan,
                                                            tx_date=datetime.date.today(),
                                                            transaction_type='Fines',
                                                            # added_by_id=userdata(request),
                                                            branch_id=branch_id)