from django.core.management import BaseCommand
from loans.models import Loans, LoanFines
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions, Account, AccountCategory
import json
from datetime import datetime
import pandas as pd


class Command(BaseCommand):
    def handle(self, *args, **options):
        branch_id = 6
        from_date = '2022/01/01'
        end_date = '2022/31/12'

        date_format = "%Y/%d/%m"
        from_date = datetime.strptime(from_date, date_format).date()
        end_date = datetime.strptime(end_date, date_format).date()

        all_loans = Loans.objects.filter(approved_on__range=(from_date, end_date), branch_id=branch_id)
        all_loans_df = pd.DataFrame.from_records(all_loans.values('applicant__biodata__name', 'amount_approved', 'approved_on'))
        # print(all_loans_df)
        all_loans_df.to_excel('loans2022.xlsx', index=False)

