from django.core.management import BaseCommand
from loans.models import Loans, UploadLoans
from loans.utils.loan_number_creation import get_new_loan_number
from datetime import datetime

from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        uploads = [
            {
                'id':309,
                'new_date': '2023/01/06'
            },
            {
                'id': 306,
                'new_date': '2023/01/06'
            },

        ]

        for up in uploads:
            date_string = up['new_date']
            print('date_string', date_string)
            date_format = "%Y/%d/%m"
            date = datetime.strptime(date_string, date_format).date()
            print('date', date)

            all_loans =Loans.objects.filter(upload_id=up['id'])
            for ln in all_loans:
                #update the transactions - give loan - charge dates
                Transactions.objects.filter(
                    loan=ln,
                    transaction_type='give loan'
                ).update(
                    tx_date=date
                )
                Transactions.objects.filter(
                    loan=ln,
                    transaction_type='loan charge'
                ).update(
                    tx_date=date
                )
