from django.core.management import BaseCommand
from django.db.models import Sum

from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_loans =Loans.objects.filter(loan_status=3)
        for ln in all_loans:
            app_amt = ln.amount_approved
            print('app_amt', app_amt)
            #given loan amount
            give_loan_transaction = Transactions.objects.filter(loan=ln, transaction_type='give loan')
            if give_loan_transaction:
                acc_dr = give_loan_transaction[0].account_dr
                acc_cr = give_loan_transaction[0].account_cr
                tx_date = give_loan_transaction[0].tx_date
                give_loan_transaction = give_loan_transaction.aggregate(
                    adjustments=Sum('reporting_amount'))['adjustments']
            else:
                give_loan_transaction = 0

            print('give_loan_transaction', give_loan_transaction)
            #charge amount
            loan_charge = Transactions.objects.filter(loan=ln, transaction_type='Loan charge').aggregate(
                loan_charge=Sum('reporting_amount'))['loan_charge']
            if loan_charge is None:
                loan_charge = 0

            print('loan_charge', loan_charge)
            print('++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++')
            extra_charge_already_added = Transactions.objects.filter(loan=ln, transaction_type='Remove extra loan charge')
            if not extra_charge_already_added:
                if give_loan_transaction > app_amt:
                    diff_transact = Transactions.objects.create(
                        loan=ln,
                        transaction_type = 'Remove extra loan charge',
                        branch=ln.branch,
                        account_dr=acc_cr,
                        account_cr = acc_dr,
                        narration = 'Remove extra loan charge',
                        tx_date = tx_date,
                        reporting_amount = loan_charge
                    )
                    print('loan updated')




