import datetime

from django.core.management import BaseCommand
from django.db.models import Sum

from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions, Account, AccountCategory


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_loans = Loans.objects.filter(loan_status=4)
        for ln in all_loans:
            try:
                ln_interest_rec_acc = Account.objects.filter(name='loan interest receivables', business=ln.branch.business)
                if ln_interest_rec_acc:
                    ln_interest_rec_acc = ln_interest_rec_acc.first()
                else:
                    print('Loan interest acc is being created')
                    ln_interest_rec_acc = Account.objects.create(
                        name='loan interest receivables', business=ln.branch.business,
                        display_name='loan interest receivables',
                        category=AccountCategory.objects.get(name='Account Receivables', business=ln.branch.business),
                    )
                ln_interest_revenue_acc = Account.objects.filter(name='Loan Interest',
                                                                 business=ln.branch.business).first()

                loan_interest_receivable_debits = Transactions.objects.filter(loan=ln, account_dr=ln_interest_rec_acc)
                # print('total debits', loan_interest_receivable_debits)
                if loan_interest_receivable_debits:
                    loan_interest_receivable_debits = \
                    loan_interest_receivable_debits.aggregate(total_debits=Sum('reporting_amount'))['total_debits']
                else:
                    loan_interest_receivable_debits = 0

                loan_interest_receivable_credits = Transactions.objects.filter(loan=ln,
                                                                               account_cr=ln_interest_rec_acc)
                # print('total credits', loan_interest_receivable_credits)
                if loan_interest_receivable_credits:
                    loan_interest_receivable_credits = \
                    loan_interest_receivable_credits.aggregate(total_credits=Sum('reporting_amount'))['total_credits']
                else:
                    loan_interest_receivable_credits = 0

                print('loan_interest_receivable_debits', loan_interest_receivable_debits, loan_interest_receivable_credits)
                if loan_interest_receivable_debits > loan_interest_receivable_credits:
                    Transactions.objects.create(
                        account_cr=ln_interest_rec_acc,
                        account_dr=ln_interest_revenue_acc,
                        loan=ln,
                        transaction_type='uncorrected interest',
                        narration='uncorrected interest',
                        tx_date=datetime.datetime.today().date(),
                        branch=ln.branch,
                        reporting_amount=(loan_interest_receivable_debits - loan_interest_receivable_credits)
                    )
                    print('THE BUSINESS',ln.branch.business.name )
                    print('===============REGISTER THE TRANSACTION================')

                # the_loan_obj.update(
                #     loan_status=4
                # )
            except Exception as e:
                print('THE ERROR', e)




