from django.core.management import BaseCommand
from loans.models import Loans, UploadLoans
from loans.utils.loan_number_creation import get_new_loan_number
from datetime import datetime

from transactions.models import Transactions


class Command(BaseCommand):
    def handle(self, *args, **options):
        uploads = [
            {
                'id':282,
                'new_date': '2023/01/05'
            },
            {
                'id': 281,
                'new_date': '2023/01/05'
            },
            {
                'id': 252,
                'new_date': '2023/01/06'
            },
            {
                'id': 249,
                'new_date': '2023/01/06'
            },
            {
                'id': 246,
                'new_date': '2023/01/05'
            },
            {
                'id': 245,
                'new_date': '2023/01/05'
            },
            {
                'id': 240,
                'new_date': '2023/01/05'
            },
            {
                'id': 239,
                'new_date': '2023/01/05'
            },
            {
                'id': 250,
                'new_date': '2023/01/06'
            },









        ]

        for up in uploads:
            date_string = up['new_date']
            print('date_string', date_string)
            date_format = "%Y/%d/%m"
            date = datetime.strptime(date_string, date_format).date()
            print('date', date)

            the_upload = UploadLoans.objects.filter(id=up['id'])
            print(the_upload)
            # the_upload = the_upload.update(
            #     upload_date=date
            # )
            print('the upload', the_upload)
            all_loans =Loans.objects.filter(upload_id=up['id'])
            for ln in all_loans:
                #update loan
                print('loan', Loans.objects.filter(id=ln.id))
                Loans.objects.filter(id=ln.id).update(
                    schedule_start= date,
                    requested_on = date,
                    approved_on = date
                )
                #update the transactions - give loan - charge dates
                Transactions.objects.filter(
                    loan=ln,
                    transaction_type='give loan'
                ).update(
                    tx_date=date
                )
                Transactions.objects.filter(
                    loan=ln,
                    transaction_type='loan charge'
                ).update(
                    tx_date=date
                )



