import datetime

from django.core.management import BaseCommand
from django.db.models import Sum

from loans.models import Loans
from django.db.models import Q
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions, Account, AccountCategory

# class Command(BaseCommand):
#     def handle(self, *args, **options):
#         all_loans =Loans.objects.filter( Q(loan_status=4) | Q(loan_status=3))
#         # 25-bunya
#         # 5-kakumba saco
#         # wanted sacco loans
#         all_loans = all_loans.filter(Q(branch__business_id=25) | Q(branch__business_id=5))
#         for ln in all_loans:
#             print('LOAN', ln, ln.branch.business.name)
#
#             the_transactions = Transactions.objects.filter(Q(transaction_type='uncorrected interest') | Q(transaction_type='Expected interest'), loan=ln).values('transaction_type')
#             print('THE TRANSACTIONS', the_transactions)
#             Transactions.objects.filter(
#                 Q(transaction_type='uncorrected interest') | Q(transaction_type='Expected interest'), loan=ln).delete()
#             print('------ transactions deleted ------------')
#         print('------ Done ------------')


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_loans = Loans.objects.filter(Q(loan_status=4) | Q(loan_status=3))
        # 25-bunya
        # 5-kakumba saco
        # wanted sacco loans
        all_loans = all_loans.filter(Q(branch__business_id=25) | Q(branch__business_id=5))
        for ln in all_loans:
            try:
                ln_interest_rec_acc = Account.objects.filter(name='loan interest receivables', business=ln.branch.business)
                if ln_interest_rec_acc:
                    ln_interest_rec_acc = ln_interest_rec_acc.first()
                else:
                    print('Loan interest acc is being created')
                    ln_interest_rec_acc = Account.objects.create(
                        name='loan interest receivables', business=ln.branch.business,
                        display_name='loan interest receivables',
                        category=AccountCategory.objects.get(name='Account Receivables', business=ln.branch.business),
                    )
                ln_interest_revenue_acc = Account.objects.filter(name='Loan Interest',
                                                                 business=ln.branch.business).first()

                loan_interest_receivable_debits = Transactions.objects.filter(loan=ln, account_dr=ln_interest_rec_acc)
                # print('total debits', loan_interest_receivable_debits)
                if loan_interest_receivable_debits:
                    loan_interest_receivable_debits = \
                    loan_interest_receivable_debits.aggregate(total_debits=Sum('reporting_amount'))['total_debits']
                else:
                    loan_interest_receivable_debits = 0

                loan_interest_receivable_credits = Transactions.objects.filter(loan=ln,
                                                                               account_cr=ln_interest_rec_acc)
                credit_transactions_all = loan_interest_receivable_credits
                # print('total credits', loan_interest_receivable_credits)
                if loan_interest_receivable_credits:
                    loan_interest_receivable_credits = \
                    loan_interest_receivable_credits.aggregate(total_credits=Sum('reporting_amount'))['total_credits']
                else:
                    loan_interest_receivable_credits = 0

                print('loan_interest_receivable_debits', loan_interest_receivable_debits, loan_interest_receivable_credits)
                if loan_interest_receivable_debits < loan_interest_receivable_credits:
                    print('THE BUSINESS', ln.branch.business.name)
                    print('LOAN DETAILS','id:', ln.id,'person', ln.applicant.biodata.name)
                    for trans in credit_transactions_all:
                        print('transactions count', trans.reporting_amount)

                        correction_trans = Transactions.objects.create(
                            # account_cr=trans.account_dr,
                            account_cr = ln_interest_revenue_acc,
                            account_dr=trans.account_cr,
                            loan=ln,
                            transaction_type='Expected interest',
                            narration='Loan interest',
                            tx_date=trans.tx_date,
                            branch=ln.branch,
                            reporting_amount=trans.reporting_amount
                        )
                        print('Tran recorded', correction_trans)

                    print('===============REGISTER THE TRANSACTION================')

                # the_loan_obj.update(
                #     loan_status=4
                # )
            except Exception as e:
                print('THE ERROR', e)




