import random

from django.core.management import BaseCommand

from sacco.models import AccountBroker


class Command(BaseCommand):
    def handle(self, *args, **options):
        my_number = 1
        def gen_account(biz, acc_no):
            if AccountBroker.objects.filter(the_account__acc_number=acc_no, business_id=biz).exists():
                return gen_account(biz, acc_no)
            return acc_no
        acc_numbers = list(AccountBroker.objects.filter(business_id=my_number).values_list('the_account__acc_number', flat=True))
        # Create an empty dictionary to store the counts of each element
        element_counts = {}

        # Count the occurrences of each element in the list
        for element in acc_numbers:
            element_counts[element] = element_counts.get(element, 0) + 1
        # Create a list of elements that appear more than once
        duplicates = [element for element, count in element_counts.items() if count > 1]
        accs = AccountBroker.objects.filter(the_account__acc_number__in=duplicates, business_id=my_number)

        for acc in accs:
            minimum = 10000000
            maximum = 99999999
            number = random.randint(minimum, maximum)
            acc_number = gen_account(my_number, number)
            acc.the_account.acc_number = acc_number
            acc.save_related()


