from django.core.management import BaseCommand
import time

from sacco.models import SmsTransaction
from sacco.utils import checkMessageStatus


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_sms = SmsTransaction.objects.filter(branch=29).order_by('-id')
        for sms in all_sms:
            print('========== start ==========================')
            time.sleep(20)
            msg_id = '155615797'
            the_status = checkMessageStatus(sms.message_id)
            print(the_status)
            if the_status == 'accepted':
                SmsTransaction.objects.filter(id=sms.id).update(
                    status=SmsTransaction.SENT)
            elif the_status == 'failed':
                SmsTransaction.objects.filter(id=sms.id).update(status=SmsTransaction.FAILED)

            print(SmsTransaction.objects.get(id=sms.id).status)


            print('========== end ==========================')