from django.core.management import BaseCommand
from django.db.models import Sum

from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions
import json
import pandas as pd


class Command(BaseCommand):
    def handle(self, *args, **options):
        the_loans = []
        #get all Loan interest paid
        # all_trans = Transactions.objects.filter(transaction_type='Loan interest', branch_id=25)
        all_loans = Loans.objects.filter(branch_id=25)

        # print('total_interest', total_interest)
        for loan in all_loans:
            total_interest = Transactions.objects.filter(transaction_type='Loan interest', loan=loan)
            total_interest = total_interest.aggregate(Sum('reporting_amount'))
            total_interest = total_interest['reporting_amount__sum']
            if total_interest is None:
                total_interest = 0
            the_loan_details ={
                'names': loan.applicant.biodata.name,
                'account_number': loan.account.acc_number,
                'principal': loan.amount_approved,
                'total_interest_paid': total_interest,
            }
            the_loans.append(the_loan_details)
            print('--added--')
        all_loans_df = pd.DataFrame.from_records(the_loans)
        # print(all_loans_df)
        all_loans_df.to_excel('Saracenloans2023.xlsx', index=False)
        print('--FINISHEDDDDDDDDD++++++++=============')