from django.core.management.base import BaseCommand

from accounts.models import Position, Staff


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        # get all positions for main branch
        all_positions = Position.objects.filter(business_id=3)
        # get all staff in new business and adjust the position
        for pos in all_positions:
            # get the new position
            the_new_pos = Position.objects.filter(title=pos.title, business_id=4)
            if the_new_pos.exists():
                the_new_pos = the_new_pos.first()
                Staff.objects.filter(position=pos, branch_id=4).update(
                    position=the_new_pos
                )