from django.core.management.base import BaseCommand

from accounts.models import Branch
from sacco.models import PublicHoliday

class Command(BaseCommand):
    help = 'Adds Ugandan public holidays to the database'

    def handle(self, *args, **kwargs):
        holidays = [
            # Fixed Date Holidays
            {"name": "New Year's Day", "day": 1, "month": 1},
            {"name": "NRM Liberation Day", "day": 26, "month": 1},
            {"name": "Archbishop Janani Luwum Day", "day": 16, "month": 2},
            {"name": "International Women's Day", "day": 8, "month": 3},
            {"name": "Labor Day", "day": 1, "month": 5},
            {"name": "Martyrs' Day", "day": 3, "month": 6},
            {"name": "Heroes' Day", "day": 9, "month": 6},
            {"name": "Independence Day", "day": 9, "month": 10},
            {"name": "Christmas Day", "day": 25, "month": 12},
            {"name": "Boxing Day", "day": 26, "month": 12},
        ]

        created_count = 0
        existing_count = 0

        # get all branches
        all_branches = Branch.objects.all()

        for br in all_branches:

            for holiday in holidays:
                # Check if holiday already exists
                holiday_exists = PublicHoliday.objects.filter(
                    name=holiday["name"],
                    day=holiday["day"],
                    month=holiday["month"],
                    branch=br,
                )

                if not holiday_exists.exists():
                    PublicHoliday.objects.create(
                        name=holiday["name"],
                        day=holiday["day"],
                        month=holiday["month"],
                        branch=br,
                    )
                    created_count += 1
                    self.stdout.write(
                        self.style.SUCCESS(f'Successfully created holiday: {holiday["name"]}')
                    )
                else:
                    holiday_exists.update(branch=br)
                    existing_count += 1
                    self.stdout.write(
                        self.style.WARNING(f'Holiday already exists: {holiday["name"]}')
                    )

            self.stdout.write(
                self.style.SUCCESS(
                    f'Command completed. Created {created_count} holidays. '
                    f'Skipped {existing_count} existing holidays.'
                )
            )

            # return