from django.core.management import BaseCommand
from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Transactions
import json


class Command(BaseCommand):
    def handle(self, *args, **options):
        # remove old loans and transactions
        acc_id = 14999
        # get all loans for
        all_loans = Loans.objects.filter(account_id=acc_id)
        for ln in all_loans:
            Transactions.objects.filter(loan=ln).delete()
            Loans.objects.filter(id=ln.id).delete()
        # ++++++++++++++++++++ done old +++++++++++++++++++++
        # Specify the file path of the JSON file
        file_path = "data.json"

        # Read the JSON data from the file
        with open(file_path, "r") as json_file:
            data = json.load(json_file)

        #add the loans
        for lon in data['loans']:
            Loans.objects.create(**lon)
            print('LOAN CREATED')
        #add the transactions
        for trans in data['transactions']:
            Transactions.objects.create(**trans)
            print('Trans CREATED')

