from django.core.management import BaseCommand
import json
from loans.models import Loans
from loans.utils.loan_details import get_all_loan_details


class Command(BaseCommand):
    def handle(self, *args, **options):
        """
        All running loans
        """
        # branch_id = 25
        branch_id = [3, 4]
        # all_loans = Loans.objects.filter(branch_id=branch_id, loan_status__gte=3)
        all_loans = Loans.objects.filter(branch_id__in=branch_id, loan_status__gte = 3)
        print(all_loans.first().branch.name)
        failed_loans = []
        for ln in all_loans:
            try:
                the_details = get_all_loan_details(ln)
                # print(ln.id, the_details['principal_in_arrears'])
                Loans.objects.filter(id=ln.id).update(
                    loan_summary_details=json.dumps(the_details),
                    balance = float(the_details['loan_balance']),
                    principal_balance = float(the_details['principal_balance']),
                    interest_balance = float(the_details['interest_balance']),
                )
            except Exception as e:
                failed_loans.append({
                    'loan_number': ln.id,
                    'business': ln.branch.business.name,
                    'reason': str(e)
                })

                try:
                    if ln.applicant is not None:
                        if ln.applicant.biodata is not None:
                            the_name = ln.applicant.biodata.name
                        else:
                            the_name = ln.applicant.name
                    else:
                        the_name = ''

                    Loans.objects.filter(id=ln.id).update(
                        loan_summary_details=json.dumps({
                            'id': str(ln.id),
                            'loan_number': str(ln.loan_number),
                            'name': '',
                            'schedule_start': '',
                            'approved_principal': 0,
                            'principal_amt': 0,
                            'disbursed_amount': 0,
                            'interest_required': 0,
                            'loan_payable': 0,
                            'principal_paid': 0,
                            'interest_paid': 0,
                            'principal_balance': 0,
                            'interest_balance': 0,
                            'loan_balance': 0,
                            'is_error': 'yes',
                            'error': '',
                            'ammotization': [],
                            'loan_officer_names': '',
                            'loan_officer_id': '',
                            'contact': '',
                            'principal_in_arrears': 0,
                            'interest_in_arrears': 0
                        })
                    )
                except:
                    Loans.objects.filter(id=ln.id).update(
                        loan_summary_details=json.dumps({
                            'id': str(ln.id),
                            'loan_number': str(ln.loan_number),
                            'name': '',
                            'schedule_start': '',
                            'approved_principal': 0,
                            'principal_amt': 0,
                            'disbursed_amount': 0,
                            'interest_required': 0,
                            'loan_payable': 0,
                            'principal_paid': 0,
                            'interest_paid': 0,
                            'principal_balance': 0,
                            'interest_balance': 0,
                            'loan_balance': 0,
                            'is_error': 'yes',
                            'error': '',
                            'ammotization': [],
                            'loan_officer_names': '',
                            'loan_officer_id': '',
                            'contact': '',
                            'principal_in_arrears': 0,
                            'interest_in_arrears': 0

                        })
                    )

        print(failed_loans)
