from django.core.management import BaseCommand
from loans.models import Loans
from loans.utils.loan_number_creation import get_new_loan_number

class Command(BaseCommand):
    def handle(self, *args, **options):
        all_loans = Loans.objects.all()
        for loan in all_loans:
            is_empty = False

            number = loan.loan_number
            if number is None:
                is_empty = True
            elif type(number) == str:
                if not number.strip():
                    is_empty = True
            else:
                is_empty = False

            if is_empty:
                Loans.objects.filter(id=loan.id).update(loan_number=get_new_loan_number())
        print('finished')

