from django.core.management import BaseCommand

from accounts.models import Staff


class Command(BaseCommand):
    def handle(self, *args, **options):
        all_staff = Staff.objects.all()

        for staff in all_staff:
            # check if the dafault business is already there in businesses
            if staff.branch.business in staff.businesses.all():
                print('NOT ADDED')
            else:
                # add it
                staff.businesses.add(staff.branch.business)