import json
import random

from django.core.management import BaseCommand

from accounts.models import Permissions
from sacco.models import AccountBroker


class Command(BaseCommand):
    def handle(self, *args, **options):
        my_number = 1
        def gen_account(biz, acc_no):
            if AccountBroker.objects.filter(the_account__acc_number=acc_no, business_id=biz).exists():
                return gen_account(biz, acc_no)
            return acc_no
        acc_numbers = AccountBroker.objects.filter(business_id=my_number)
        empty_accounts = []

        # Count the occurrences of each element in the list
        for element in acc_numbers:
            if element.the_account.acc_number is None or element.the_account.acc_number == '':
                empty_accounts.append(element.the_account.id)

        accs = AccountBroker.objects.filter(the_account_id__in=empty_accounts, business_id=my_number)
        print(accs)

        for acc in accs:
            minimum = 10000000
            maximum = 99999999
            number = random.randint(minimum, maximum)
            acc_number = gen_account(my_number, number)
            acc.the_account.acc_number = acc_number
            acc.save_related()


