from django.core.exceptions import PermissionDenied

from accounts.models import Permissions


def can_do_this(function):
    def wrap(ti, request, *args, **kwargs):
        perms, created = Permissions.objects.get_or_create(item_name=ti.deco_role)
        # print(perms.item_name)
        user_role = ti.request.user.staff.position
        perms_in_role = list(user_role.permissions.all().values_list('id', flat=True))
        if perms.id in perms_in_role:
            return function(ti, request, *args, **kwargs)
        else:
            raise PermissionDenied

    wrap.__doc__ = function.__doc__
    wrap.__name__ = function.__name__
    return wrap
