from django.conf import settings
from django.db.models import Q

from accounts.models import Branch, Permissions, Business
from sacco.models import FinancialYear, CustomBusiness
from sacco.utils import session_business_data


def fy(request):
    try:
        fin_year = FinancialYear.objects.filter(business=request.user.staff.branch.business)
        return {"fy": fin_year}
    except:

        return {"fy": None}


def allbranches(request):

    EXCLUDED_PREFIXES = [
        '/nugsoft-staff/',  # This will exclude /excluded-url-1/ and anything under it
        '/nugsoft-admin/',
        '/accounts/',
    ]
    current_path = request.path
    if any(current_path.startswith(prefix) for prefix in EXCLUDED_PREFIXES):
        return {"vbranches": None}
    business_context = session_business_data(request)

    try:
        if business_context is None:
            instance_type = request.user.staff.branch.business.instance_type
            branches = Branch.objects.filter(business__instance_type=instance_type)
        else:
            branches = Branch.objects.filter(business=business_context)
        # branches = Branch.objects.filter(Q(business=request.user.staff.branch.business),
        #                                  ~Q(id=request.user.staff.branch.id))
        return {"vbranches": branches}
    except:
        return {"vbranches": None}


def branch(request):
    try:
        branch = Branch.objects.get(id=request.user.staff.branch.id)
        return {"mybranch": branch}
    except:
        return {"mybranch": None}


def setup_business_filters(request):
    EXCLUDED_PREFIXES = [
        '/nugsoft-staff/',  # This will exclude /excluded-url-1/ and anything under it
        '/nugsoft-admin/',
        '/accounts/',
    ]
    current_path = request.path
    if any(current_path.startswith(prefix) for prefix in EXCLUDED_PREFIXES):
        return {
            'show_business_filters': False,
            'businesses_list_filter': []
        }
    # show business filters
    business_context = session_business_data(request)
    if business_context is None:
        instance_type = request.user.staff.branch.business.instance_type
        all_businesses = Branch.objects.filter(business__instance_type=instance_type)
        return {
            'show_business_filters': True,
            'businesses_list_filter': all_businesses
        }
    else:
        return {
            'show_business_filters': False,
            'businesses_list_filter': []
        }



def system_perms(request):
    perms = list(Permissions.objects.all().values_list('item_name', flat=True))
    # print(perms)

    return {'system_perms': perms}


def user_perms(request):
    try:
        user_role = request.user.staff.position
        perms_in_role = list(user_role.permissions.all().values_list('item_name', flat=True))
        # print(perms_in_role)
        return {'user_perms': perms_in_role}
    except AttributeError:
        return {'user_perms': []}


def am_namayingo(request):
    is_true = CustomBusiness.objects.filter(business_module='NAMAMYINGO').first()
    if is_true:

        return {'am_namayingo': True}
    return {'am_namayingo': False}


def new_side_bar(request):
    new_bar = settings.NEW_SIDE_BAR
    if new_bar is True:
        return {'new_side_bar': True}
    return {'new_side_bar': False}

def view_groups(request):
    vew_group = settings.VIEW_GROUPS
    if vew_group is True:
        return {'view_groups': True}
    return {'view_groups': False}
