from django.shortcuts import redirect
from django.contrib.auth import logout
from django.urls import reverse
from django.utils import timezone

class After5PermissionMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        response = self.get_response(request)

        # Check if the user is logged in and if not, do nothing
        if not request.user.is_authenticated:
            return response

        # Check if the user has the required permission
        # Get the current server time in a timezone-aware datetime object
        current_server_time = timezone.now()
        # print('current_server_time', current_server_time)

        # Set the target time to 5:00 PM
        # NOTE: SERVER IS 3 HOURS BEHIND SO 5pm is (17-3)hr
        target_time = current_server_time.replace(hour=14, minute=0, second=0, microsecond=0)
        # target_time = current_server_time.replace(hour=11, minute=0, second=0, microsecond=0)

        # Check if the current server time is past 5:00 PM
        is_past_5_pm = current_server_time >= target_time

        # Print or use the result as needed
        if is_past_5_pm:
            # print('WE ARE HERE')
            can_login_overtime = False
            if request.user.staff is not None:
                if request.user.staff.position.permissions.filter(item_name='can_login_overtime').exists():
                    can_login_overtime = True
                
                if not can_login_overtime:
                    # Log out the user if they don't have the required permission
                    logout(request)

                    # Redirect to a login page or any other page you prefer
                    login_url = reverse('login')
                    return redirect(login_url)

        return response