from django.contrib import admin
from django import forms
from django.contrib.admin import display

from accounts.models import Business, SubscriptionPackage, Staff, Salutation, Branch, Permissions, Position, \
    Payroll
from sacco.models import AccountTypes, Member, MemberAccount, \
    TransactionCharge, FinancialYear, LicenseKey, GeneratedPassword, \
    OtherSettings, AccountBroker, SaccoSmsSettings, CurrencySetting, Sms, SmsTransaction, GroupMember, NotiSettings, \
    BusinessShares, ChargeSchedule, UserMember, PaymentTransaction, SMSCost, WithdrawUpload, CustomBusiness, \
    MemberUpload, SavingUpload, AutomatedCharge



class PermForm(forms.ModelForm):
    description = forms.CharField()

    class Meta:
        exclude = ['description']

    def clean(self):
        cleaned_data = super().clean()
        description = cleaned_data['description']
        name = description.lower()
        item_name = name.replace(' ', '_')
        Permissions.objects.create(description=description, item_name=item_name)


@admin.register(Business)
class BusinessAdmin(admin.ModelAdmin):
    list_display = ['name']


class BiodataAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'contact']
    list_filter = ['date_created']


class PositionAdmin(admin.ModelAdmin):
    list_display = ['title', 'business_name']
    filter_horizontal = ['permissions']

    @display(ordering='business__name', description='Business')
    def business_name(self, obj):
        return obj.business.name


@admin.register(Permissions)
class PermAdmin(admin.ModelAdmin):
    list_display = ['description', 'item_name']
    exclude = ['item_name']


class SmsAdmin(admin.ModelAdmin):
    list_display = ['created_date']
    list_filter = ['created_date']
    # form = PermForm


class MemberAdmin(admin.ModelAdmin):
    list_display = ['member_name', 'branch', 'is_group', 'is_active']
    list_filter = ['is_group', 'is_active']
    search_fields = ['biodata__name']

    @display(ordering='id', description='Members')
    def member_name(self, obj):
        if obj.is_group is False:
            return obj.biodata
        else:
            return obj.name


class MemberAccountAdmin(admin.ModelAdmin):
    list_display = ['acc_number', 'business', 'id']
    search_fields = ['acc_number']
    # list_filter = ['business']

    @display(description='Business')
    def business(self, obj):
        if obj is not None:
            my_broker = AccountBroker.objects.get(the_account=obj)

            return my_broker.business.name

@admin.register(Staff)
class StaffAdmin(admin.ModelAdmin):
    list_filter = ['biodata__name']

admin.site.register(Position, PositionAdmin)
admin.site.register([Salutation, GeneratedPassword, GroupMember])
admin.site.register(Branch)
admin.site.register(UserMember)
admin.site.register(AccountTypes)
admin.site.register(TransactionCharge)
admin.site.register(SubscriptionPackage)
admin.site.register(FinancialYear)
admin.site.register(Member, MemberAdmin)
admin.site.register(MemberAccount, MemberAccountAdmin)
admin.site.register(OtherSettings)
admin.site.register([AccountBroker, ChargeSchedule])
admin.site.register(SaccoSmsSettings)
admin.site.register(LicenseKey)
# admin.site.register(Currency)
admin.site.register(CurrencySetting)
admin.site.register(Sms)
admin.site.register(SmsTransaction, SmsAdmin)
admin.site.register(NotiSettings)
admin.site.register(WithdrawUpload)
admin.site.register(SavingUpload)
admin.site.register(AutomatedCharge)

#shares
admin.site.register(BusinessShares)

# class StuffAdmin(admin.ModelAdmin):
#     list_display = ['biodata__name']

@admin.register(PaymentTransaction)
class SubAdmin(admin.ModelAdmin):
    list_display = ['txt_id', 'status']

admin.site.register(SMSCost)
admin.site.register(Payroll)
admin.site.register(CustomBusiness,)
admin.site.register(MemberUpload,)
# admin.site.register(NewSideBarSetting,)
