from django.urls import path

from mufukoadmin.views import AdminIndex, AllBusinesses, AddBusiness, ManagePackages, UpdatePackages, DeletePackages, \
    LicenseKeys, BusinessProfile, ManageBusiness, ActiveBusinesses, InactiveBusinesses, ExtendLicense, SMSPackages, UpdateSmsPackages, DeleteSmsPackages

urlpatterns = [
    path('', AdminIndex.as_view(), name='nug_admin'),
    path('businesses/all', AllBusinesses.as_view(), name='businesses'),
    path('businesses/active', ActiveBusinesses.as_view(), name='active'),
    path('businesses/inactive', InactiveBusinesses.as_view(), name='inactive'),
    path('businesses/create', AddBusiness.as_view(), name='add_business'),
    path('packages', ManagePackages.as_view(), name='packages'),
    path('update-package/<int:pk>', UpdatePackages.as_view(), name='update_package'),
    path('delete-package/<int:pk>', DeletePackages.as_view(), name='delete_package'),
    path('licenses', LicenseKeys.as_view(), name='licenses'),
    path('extend-license/<int:pk>/', ExtendLicense.as_view(), name='extend_license'),
    path('business/<int:pk>/', BusinessProfile.as_view(), name='business'),
    path('manage-business/<int:pk>/', ManageBusiness.as_view(), name='manage_business'),
    path('sms_packages', SMSPackages.as_view(), name='sms_packages'),
    path('update-sms-package/<int:pk>', UpdateSmsPackages.as_view(), name='update_sms_package'),
    path('delete-sms-package/<int:pk>', DeleteSmsPackages.as_view(), name='delete_sms_package')
]
