from django import forms

from accounts.models import SubscriptionPackage, Business
from sacco.models import LicenseKey, MessagePackage


class PackageCreateForm(forms.ModelForm):
    class Meta:
        model = SubscriptionPackage
        fields = ('name', 'limit',)


class ManageBusinessForm(forms.ModelForm):
    class Meta:
        model = Business
        fields = ('status',)


class LicenseExtendForm(forms.ModelForm):
    class Meta:
        model = LicenseKey
        fields = ('expiry_date',)


class MessagePackageForm(forms.ModelForm):
    class Meta:
        model = MessagePackage
        fields = ('name', 'price', 'sms')
