"""mfuko URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path, include, re_path
from django.views.generic import RedirectView
from django.views.static import serve
from drf_yasg import openapi
from drf_yasg.views import get_schema_view
from rest_framework import permissions

handler404 = "sacco.exception_handler.error_404_page"
handler400 = "sacco.exception_handler.error_400_page"
handler403 = "sacco.exception_handler.error_403_page"
handler500 = "sacco.exception_handler.error_500_page"

schema_view = get_schema_view(
    openapi.Info(
        title="Mfuko Portal API",
        default_version='v1',
        description="Mfuko for members",
        terms_of_service="https://www.google.com/policies/terms/",
        contact=openapi.Contact(email="larryoketcho@gmail.com"),
        license=openapi.License(name="BSD License"),
    ),
    public=True,
    permission_classes=[permissions.AllowAny],
)


def trigger_error(request):
    division_by_zero = 1 / 0


urlpatterns = [
    path('glitchtip-debug/', trigger_error),
    # path('__debug__/', include('debug_toolbar.urls')),
    re_path(r'^swagger(?P<format>\.json|\.yaml)$', schema_view.without_ui(cache_timeout=0),
            name='schema-json'),
    re_path(r'^swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    re_path(r'^redoc/$', schema_view.with_ui('redoc', cache_timeout=0), name='schema-redoc'),
    path('nugsoft-staff/', admin.site.urls),
    path('', include('sacco.urls')),
    path('accounts/', include('accounts.urls')),
    path('loans/', include('loans.urls')),
    path('new-loans/', include('loans.new_urls')),
    path('transactions/', include('transactions.urls')),
    path('nugsoft-admin/', include('mufukoadmin.urls')),
    path('favicon.ico', RedirectView.as_view(url='/static/sacco/assets/images/admin-logox.png')),
    path('django-rq/', include('django_rq.urls')),
    path('api/v1/', include('apis.urls')),
    path('namayingo/', include('client_custom.namayingo.urls')),

    re_path(r'^media/(?P<path>.*)$', serve, {'document_root': settings.MEDIA_ROOT}),
    re_path(r'^static/(?P<path>.*)$', serve, {'document_root': settings.STATIC_ROOT}),
]
if 'debug_toolbar' in settings.INSTALLED_APPS:
    urlpatterns += [
        path('__debug__/', include('debug_toolbar.urls')),
    ]

if 'silk' in settings.INSTALLED_APPS:
    urlpatterns += [path('silk/', include('silk.urls', namespace='silk'))]
