import json
import pandas as pd
import copy
import ast
from datetime import *
from dateutil.relativedelta import relativedelta
from math import ceil, floor
from django.db.models import Q, F, FloatField, Case, When, Sum

from accounts.models import Branch
from sacco.models import LoanSettings, PublicHoliday
from transactions.models import Transactions, Account
from loans.models import ApplicationAccountOrLoanType, LoanFinePayments, LoanFines, LoanTopups, LoanUpload, Loans, LoanCharges
from sacco.utils import (
    businessdata,
    branchdata, session_business_data, determine_business_id_list,
)


def adjust_schedule_date(schedules, loan, index):
    # get the public holidays
    all_holidays = PublicHoliday.objects.filter(branch=loan.branch)
    public_holiday_dates = {(holiday.day, holiday.month) for holiday in all_holidays}

    updated_data = []
    cumulative_adjustment = 0  # Track total days shifted

    for entry in schedules:
        date_str = entry[index]
        date_obj = datetime.strptime(date_str, '%Y-%m-%d')

        # Apply any cumulative adjustment from previous entries
        date_obj += timedelta(days=cumulative_adjustment)

        # Extract the day and month from the adjusted date
        date_day_month = (date_obj.day, date_obj.month)

        # Check if the day and month match any public holiday
        days_shifted = 0
        while date_day_month in public_holiday_dates:
            # Move to the next day (or week as in your original code)
            date_obj += timedelta(days=7)
            days_shifted += 7
            # Update the day and month for the next iteration
            date_day_month = (date_obj.day, date_obj.month)

        # Add this entry's adjustment to the cumulative total
        cumulative_adjustment += days_shifted

        # Update the date in the entry
        entry[index] = date_obj.strftime('%Y-%m-%d')
        updated_data.append(entry)

    return updated_data


def adjust_schedule_date_loan_summary(schedules, loan):
    # get the public holidays
    all_holidays = PublicHoliday.objects.filter(branch=loan.branch)
    public_holiday_dates = {(holiday.day, holiday.month) for holiday in all_holidays}

    updated_data = []
    cumulative_adjustment = 0  # Track total days shifted

    for entry in schedules:
        date_str = entry['schedule_date']
        date_obj = datetime.strptime(date_str, '%Y-%m-%d')

        # Apply any cumulative adjustment from previous entries
        date_obj += timedelta(days=cumulative_adjustment)

        # Extract the day and month from the adjusted date
        date_day_month = (date_obj.day, date_obj.month)

        # Check if the day and month match any public holiday
        days_shifted = 0
        while date_day_month in public_holiday_dates:
            # Move to the next week
            date_obj += timedelta(days=7)
            days_shifted += 7
            # Update the day and month for the next iteration
            date_day_month = (date_obj.day, date_obj.month)

        # Add this entry's adjustment to the cumulative total
        cumulative_adjustment += days_shifted

        # Update the date in the entry
        entry['schedule_date'] = date_obj.strftime('%Y-%m-%d')
        updated_data.append(entry)

    return updated_data


#NOTE: the_loan is an obj for Loans model
def get_loan_amounts_paid(the_loan):
    
    #total principal paid
    total_principal = Transactions.objects.filter(loan=the_loan, transaction_type='Loan repayment').aggregate(total=Sum("reporting_amount"))['total']
    if total_principal is None:
        total_principal = 0
    total_interest = Transactions.objects.filter(loan=the_loan, transaction_type='Loan interest').aggregate(total=Sum("reporting_amount"))['total']
    if total_interest is None:
        total_interest = 0

    total_fines = Transactions.objects.filter(loan=the_loan, transaction_type='Loan fines').aggregate(total=Sum("reporting_amount"))['total']
    if total_interest is None:
        total_fines = 0
    
    return{
        'total_principal':total_principal,
        'total_interest': total_interest,
        'total_fines': total_fines
    }

def get_total_charges(the_loan):
    #ORIGINAL IN MAIN MFUKO
    # actualchargesx = the_loan.charges
    # totalcharges = 0
    # try:
    #     actualcharges = json.loads(actualchargesx)
    #     for chg in actualcharges:
    #         chargeamount = chg["amount"]
    #         totalcharges = totalcharges + chargeamount

    # except:
    #     totalcharges = 0

    totalcharges = LoanCharges.objects.filter(loan=the_loan).aggregate(total=Sum("amount"))['total']
    if totalcharges is None:
        totalcharges = 0

    return totalcharges


def determine_loan_principal(the_loan):
    #get the loan receivables account for business
    ln_receivables_acc = Account.objects.get(name="Loan Receivables", business=the_loan.branch.business)

    given_principal = Transactions.objects.filter(loan=the_loan, account_dr=ln_receivables_acc).aggregate(total=Sum("reporting_amount"))['total']
    if given_principal is None:
        given_principal = 0
    return given_principal

def determine_disbursed_amount(the_loan):
    disbursed_principal = Transactions.objects.filter(loan=the_loan, transaction_type='give loan').aggregate(total=Sum("reporting_amount"))['total']
    if disbursed_principal is None:
        disbursed_principal = 0
    return disbursed_principal
    

def get_loan_interval(the_loan):
    if the_loan.interval is not None:
        typeinterval = the_loan.interval
    else:
        typeinterval = the_loan.loan_type.interval
    return typeinterval


def determine_interest_percentage(the_loan, formula, loan_interval):
    if formula == 5:
        interest = the_loan.rate / 100

    if formula == 1:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) / 12

        if loan_interval == 0:
            interest = (the_loan.rate / 100) / 365

        if loan_interval == 1:
            interest = (the_loan.rate / 100) / 52

        if loan_interval == 2:
            interest = (the_loan.rate / 100) / 26

        if loan_interval == 4:
            interest = the_loan.rate / 100

    if formula == 2:
        if loan_interval == 3:
            interest = the_loan.rate / 100

        if loan_interval == 0:
            interest = (the_loan.rate / 100) / 30

        if loan_interval == 1:
            interest = (the_loan.rate / 100) / 4

        if loan_interval == 2:
            interest = (the_loan.rate / 100) / 2

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 12

    if formula == 3:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) * 4

        if loan_interval == 0:
            interest = (the_loan.rate / 100) * 7

        if loan_interval == 1:
            interest = the_loan.rate / 100

        if loan_interval == 2:
            interest = (the_loan.rate / 100) * 2

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 52

    if formula == 4:
        if loan_interval == 3:
            interest = (the_loan.rate / 100) * 30

        if loan_interval == 0:
            interest = the_loan.rate / 100

        if loan_interval == 1:
            interest = (the_loan.rate / 100) * 7

        if loan_interval == 2:
            interest = (the_loan.rate / 100) * 14

        if loan_interval == 4:
            interest = (the_loan.rate / 100) * 365
    
    return interest

def determine_duration_sizes(the_loan, loan_interval):
    duration = the_loan.approved_duration
    # =====================IF INTERVAL IS MONTHLY =========================
    if loan_interval == 3:
        to_add = relativedelta(months=1)
        try:
            all_duration = relativedelta(months=duration)
        except Exception as exp:
            # print(str(exp))
            pass

    # =====================IF INTERVAL IS DAILY =========================

    if loan_interval == 0:
        to_add = relativedelta(days=1)
        all_duration = relativedelta(days=duration)

    # =====================IF INTERVAL IS WEEKLY =========================

    if loan_interval == 1:
        to_add = relativedelta(weeks=1)
        all_duration = relativedelta(weeks=duration)

    # =====================IF INTERVAL IS BI-WEEKLY =========================

    if loan_interval == 2:
        to_add = relativedelta(weeks=2)
        all_duration = relativedelta(weeks=duration * 2)

    # =====================IF INTERVAL IS YEARLY =========================

    if loan_interval == 4:
        to_add = relativedelta(years=1)
        all_duration = relativedelta(years=int(duration))
    
    return {
        'to_add': to_add,
        'all_duration': all_duration
    }

def flat_rate_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration ):
    nextinterest = 0
    cumrative_payments = 0
    approved_amount = the_loan.amount_approved
    duration = the_loan.approved_duration
    interest = interest_size
    paidamount = totals_paid['total_principal'] + totals_paid['total_interest']
    appdate = the_loan.schedule_start
    principal = given_principal
    decimals=5
    cumrative_payments = 0

    #interests paid
    if totals_paid['total_interest'] > 0:
        intpaid = 1
    else:
        intpaid = 0

    # today's date
    nowdate = datetime.today().date()

    if the_loan.rate_type == 1:
        days = []
        schedules = approved_amount / duration
        interestperschedue = approved_amount * interest
        payable = interestperschedue + schedules
        # ========================================GET PAID SCHEDULES=========================
        paidschedules = paidamount / payable
        paidschedules = floor(paidschedules)

        # ====================================Balance for the next schedule=======================
        nextbal = paidamount - (payable * paidschedules)
        nextintallment = payable - nextbal

        # print('NeXT INSTALL ', nextintallment, 'bal ', nextbal)
        if 1 > nextintallment > 0:
            nextintallment = payable + nextintallment
            nextschedule = paidschedules + 2
        else:
            nextschedule = paidschedules + 1

        # print('to_add', to_add)

        to_add = to_add[0]
        edate = appdate + to_add
        # print(appdate)
        date1 = edate
        totalpayable = payable * duration

        totalinterest = totalpayable - principal

        totalinterest = round(totalinterest, decimals)

        totalpayable = round(totalpayable, decimals)

        rbalance = totalpayable

        date2 = date1 + all_duration
        m = 1

        total_interest_paid = totals_paid['total_interest']
        total_principal_paid = totals_paid['total_principal']

        try:
            principalbalance = principal

            sch_date = date1
            # while date1 < date2:

            while m <= duration:
                pbalance = 0

                if intpaid == m or intpaid > m:
                    actualinterest = 0
                else:
                    actualinterest = interestperschedue

                rbalance = rbalance - payable
                rbalance = rbalance
                if m == nextschedule:
                    isnext = 1
                    spaid = nextbal
                    sbalance = nextintallment

                elif m < nextschedule:
                    isnext = 0
                    spaid = payable
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = payable


                principalbalance = principalbalance - schedules

                #determine how much has been paid on interest and principal
                if float(total_principal_paid) > float(schedules):
                    current_principal_paid = schedules
                    current_principal_bal = 0
                else:
                    current_principal_paid = total_principal_paid
                    current_principal_bal = float(schedules) - current_principal_paid

                total_principal_paid = total_principal_paid - current_principal_paid


                days.append(
                    {
                        'schedule_date' : date1.strftime("%Y-%m-%d"),
                        'total_paid': round(spaid, decimals),
                        'schedule_balance':round(sbalance, decimals),
                        'principal_balance':round(principalbalance, decimals),
                        'installment':round(payable, decimals),
                        'principal_per_schedule': schedules,
                        'interestperschedue': interestperschedue,
                        'current_principal_paid': current_principal_paid,
                        'current_principal_bal': current_principal_bal
                    }
                )

                payable = round(payable, decimals)
                schedules = round(schedules, decimals)
                interestperschedue = round(interestperschedue, decimals)
                if date1.weekday() == 5:
                    date1 = date1 + to_add + relativedelta(days=1)
                    date2 = date2 + relativedelta(days=1)

                else:
                    date1 = date1 + to_add

                sfine = 0

                m = m + 1
        except Exception as erp:
            print("ERROR %", str(erp))
    return days



def reducing_balance_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration):
    total_interest_paid = totals_paid['total_interest']
    total_principal_paid = totals_paid['total_principal']

    if the_loan.rate_type == 2:
        in_date = ""
        loan_dict = {}
        data = []
        days = []

        to_add = to_add[0]
        approved_amount = the_loan.amount_approved
        duration = the_loan.approved_duration
        interest = interest_size
        paidamount = totals_paid['total_principal'] + totals_paid['total_interest']
        appdate = the_loan.schedule_start
        principal = given_principal
        decimals = 5
        cumrative_payments = 0
        # today's date
        nowdate = datetime.today().date()

        #interests paid
        if totals_paid['total_interest'] > 0:
            intpaid = 1
        else:
            intpaid = 0

        edate = appdate + to_add
        date1 = edate
        principals = 0
        date2 = date1 + all_duration
        runningbal = approved_amount
        if principal == 0:
            print('principal was zero')
            principal = the_loan.approved_amount
        if interest > 0:
            numilator = (
                principal
                * interest
                * (
                    (pow((1 + interest), duration))
                    / (pow((1 + interest), duration) - 1)
                )
            )
        else:
            numilator = principal / duration

        if numilator == 0:
            print(principal, interest)
        
        payable = numilator

        totalpayable = payable * duration

        totalpayable = totalpayable

        rprincipal = 0
        rbalance = principal
        # ========================================GET PAID SCHEDULES=========================

        paidschedules = paidamount / payable
        paidschedules = floor(paidschedules)

        # print('PAID SCHEDULES ARE ', paidschedules, 'Paid Is ', paidamount, 'Payabale is ', payable)

        # ====================================Balance for the next schedule=======================
        nextbal = paidamount - (payable * paidschedules)
        # nextintallment = payable + float(totaladjustments) - nextbal
        # removed the original total adjustments
        nextintallment = payable - nextbal
        # print('NeXT INSTALL ',nextintallment, 'bal ',nextbal )
        if nextintallment < 1 and nextintallment > 0:
            nextintallment = payable + nextintallment
            nextschedule = paidschedules + 2
        else:
            nextschedule = paidschedules + 1
        m = 1
        isnext = 0
        sfine = 0
        sch_date = date1

        if the_loan.sub_intervals == True:
            if the_loan.interval == 4:
                pricipalperschdule = principal / duration
                paymentperiod = []
                remainingprincipal = principal
                rem_principal = principal

                # gettotalinterest
                totalinterest = 0
                for a in range(0, int(duration)):
                    perinterest = rem_principal * interest
                    yearlypayable = rem_principal + perinterest
                    rem_principal = rem_principal - pricipalperschdule
                    totalinterest = totalinterest + perinterest

                pbalance = principal
                sch_date = date1
                # while date1 < date2:
                while m <= duration:
                    date3 = date1 - relativedelta(years=1)
                    runningbal = principal + totalinterest
                    for a in range(0, int(duration)):
                        generalint = remainingprincipal * interest
                        generalpayable = pricipalperschdule + generalint
                        interestperschedue = generalint / 12
                        interestperschedue = round(interestperschedue, 2)
                        payable = generalpayable / 12
                        rprincipal = payable - interestperschedue
                        # rprincipal = round(rprincipal, decimals)

                        paidschedules = paidamount / payable
                        paidschedules = floor(paidschedules)

                        for sched in range(0, 12):
                            nextbal = paidamount - (payable * paidschedules)
                            nextintallment = payable - nextbal
                            if nextintallment < 1 and nextintallment > 0:
                                nextintallment = payable + nextintallment
                                nextschedule = paidschedules + 2
                            else:
                                nextschedule = paidschedules + 1

                            sfine = 0
                            sfines = 0
                            if m == nextschedule:
                                isnext = 1
                                if nextbal < 1:
                                    spaid = 0
                                else:
                                    spaid = round(nextbal, decimals)
                                sbalance = round(
                                    ##--- Original line
                                    # nextintallment + totaladjustments, decimals
                                    ##--- New line
                                    nextintallment , decimals
                                )

                            elif m < nextschedule:
                                isnext = 0
                                spaid = round(payable, decimals)
                                sbalance = 0

                            else:
                                isnext = 2
                                spaid = 0
                                sbalance = round(payable, decimals)

                            days.append(date1.strftime("%Y-%m-%d"))

                            # if date1 < nowdate and isnext > 0:
                            #     for loanfine in loanfines:
                            #         fineamount = loanfine.general_charge.amount
                            #         if (
                            #             loanfine.general_charge.is_percentage
                            #             == True
                            #         ):
                            #             sfines = (fineamount / 100) * payable
                            #         else:
                            #             sfines = fineamount

                            #         sfine = float(sfine) + float(sfines)
                            # else:
                            #     sfine = 0
                            sfine = 0

                            sfine = round(sfine, decimals)

                            runningbal = runningbal - payable
                            rbalance = round(runningbal, decimals)

                            if intpaid == m or intpaid > m:
                                actualinterest = 0

                            else:
                                actualinterest = interestperschedue

                            pbalance = pbalance - rprincipal
                            if spaid > 1:
                                cumrative_payments = cumrative_payments + spaid

                            else:
                                cumrative_payments = 0

                            loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                            loan_dict[rprincipal] = rprincipal
                            loan_dict[rbalance] = rbalance
                            loan_dict[isnext] = isnext
                            loan_dict[interestperschedue] = interestperschedue
                            loan_dict[spaid] = spaid
                            loan_dict[sbalance] = sbalance
                            loan_dict[actualinterest] = actualinterest
                            data.append(
                                [
                                    round(rprincipal, decimals),
                                    loan_dict[in_date],
                                    loan_dict[round(rbalance, decimals)],
                                    loan_dict[
                                        round(interestperschedue, decimals)
                                    ],
                                    loan_dict[round(isnext, decimals)],
                                    loan_dict[round(spaid, decimals)],
                                    loan_dict[round(sbalance, decimals)],
                                    loan_dict[actualinterest],
                                    sfine,
                                    round(payable, decimals),
                                    round(pbalance, decimals),
                                    round(cumrative_payments, decimals),
                                ]
                            )

                            if date1.weekday() != 5:
                                date1 = date1 + to_add
                            else:
                                date1 = date1 + to_add + relativedelta(days=1)
                                date2 = date2 + relativedelta(days=1)

                            # date1 = sch_date + m * to_add
                            date3 = sch_date + relativedelta(months=m)
                            m = m + 1

                            sfine = 0

                        remainingprincipal = (
                            remainingprincipal - pricipalperschdule
                        )
                ## -- original
                # generalbalance = (totalpayable + totaladjustments) - (
                #     adjustment_down - adjustment_added
                # )
                generalbalance = totalpayable 

                # -------- review this ------------------
                try:
                    if generalbalance == 0 or generalbalance < 1:
                        generalbalance = 0
                        the_loan.loan_status = 4

                except:
                    pass
                generalbalance = round(generalbalance, decimals)
                the_loan.balance = generalbalance
                the_loan.save()
                # ------------- end review -------------------

            # print('PRINCIPAL Five', principal)

            if the_loan.interval == 3:
                # print('I AM IN THE MONTH')
                pricipalperschdule = principal / duration
                paymentperiod = []
                remainingprincipal = principal
                rem_principal = principal
                segments = ceil(duration / 12)
                actualyears = floor(duration / 12)
                halfyear = duration - (actualyears * 12)

                totalinterest = 0
                for a in range(0, int(actualyears)):
                    perinterest = rem_principal * interest * 12
                    # print('CUMLATIVE INT',perinterest )
                    yearlypayable = rem_principal + perinterest
                    rem_principal = rem_principal - pricipalperschdule * 12
                    totalinterest = totalinterest + perinterest
                    paymentperiod.append(12)
                # ====FOR THE BALANCE OF MONTH==========================

                if halfyear > 0:
                    perinterest = rem_principal * interest * halfyear
                    totalinterest = totalinterest + perinterest
                    paymentperiod.append(halfyear)
                # print('PERIODS ', halfyear)
                pbalance = principal
                date3 = date1
                # print('runningbal ', runningbal)
                # print('totalinterest ', totalinterest)
                runningbal = principal + totalinterest
                index = 0
                for a in paymentperiod:
                    if a < 12:
                        generalint = remainingprincipal * interest
                    else:
                        generalint = remainingprincipal * interest * (a / 12)
                    generalpayable = pricipalperschdule + generalint
                    interestperschedue = generalint
                    interestperschedue = interestperschedue
                    payable = generalpayable
                    rprincipal = payable - interestperschedue

                    paidschedules = paidamount / payable
                    paidschedules = floor(paidschedules)

                    for sched in range(0, int(a)):
                        nextbal = paidamount - (payable * paidschedules)
                        nextintallment = payable - nextbal

                        if nextintallment < 1 and nextintallment > 0:
                            nextintallment = payable + nextintallment
                            nextschedule = paidschedules + 2
                        else:
                            nextschedule = paidschedules + 1

                        sfine = 0
                        sfines = 0
                        if m == nextschedule:
                            isnext = 1
                            if nextbal < 1:
                                spaid = 0
                            else:
                                spaid = nextbal
                            sbalance = nextintallment

                        elif m < nextschedule:
                            isnext = 0
                            spaid = payable
                            sbalance = 0

                        else:
                            isnext = 2
                            spaid = 0
                            sbalance = payable

                        days.append(date1.strftime("%Y-%m-%d"))

                        # if date1 < nowdate and isnext > 0:
                        #     for loanfine in loanfines:
                        #         fineamount = loanfine.general_charge.amount
                        #         if (
                        #             loanfine.general_charge.is_percentage
                        #             == True
                        #         ):
                        #             sfines = (fineamount / 100) * payable
                        #         else:
                        #             sfines = fineamount

                        #         sfine = float(sfine) + float(sfines)
                        # else:
                        #     sfine = 0

                        sfine = 0

                        sfine = round(sfine, decimals)

                        runningbal = runningbal - payable
                        rbalance = runningbal
                        if intpaid == m or intpaid > m:
                            actualinterest = 0

                        else:
                            actualinterest = interestperschedue

                        pbalance = pbalance - rprincipal
                        if spaid > 0:
                            cumrative_payments = cumrative_payments + spaid

                        else:
                            cumrative_payments = 0

                        loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                        loan_dict[rprincipal] = rprincipal
                        loan_dict[rbalance] = rbalance
                        loan_dict[isnext] = isnext
                        loan_dict[interestperschedue] = interestperschedue
                        loan_dict[spaid] = spaid
                        loan_dict[sbalance] = sbalance
                        loan_dict[actualinterest] = actualinterest
                        if rbalance < 1:
                            rbalance = 0

                        if rprincipal < 1:
                            rprincipal = 0

                        if pbalance < 1:
                            pbalance = 0

                        data.append(
                            [
                                round(rprincipal, decimals),
                                loan_dict[in_date],
                                round(rbalance, decimals),
                                round(interestperschedue, decimals),
                                loan_dict[round(isnext, decimals)],
                                round(spaid, decimals),
                                round(sbalance, decimals),
                                round(actualinterest, decimals),
                                sfine,
                                round(payable, decimals),
                                round(pbalance, decimals),
                                round(cumrative_payments, decimals),
                            ]
                        )
                        date3 = sch_date + relativedelta(months=m)
                        date1 = sch_date + m * to_add
                        m = m + 1
                        sfine = 0
                        # date1 = date1 + to_add
                        # date1 = sch_date + m * to_add
                        # date3 = date3 + relativedelta(months=1)

                    index = index + 1
                    remainingprincipal = (
                        remainingprincipal - pricipalperschdule * 12
                    )

        else:
            pbalance = principal
            sch_date = date1

            ## --original
            # generalbalance = (totalpayable + totaladjustments - paidamount) - (
            #     adjustment_down - adjustment_added
            # )
            ##--New
            generalbalance = (totalpayable - paidamount) 
            try:
                if generalbalance == 0 or generalbalance < 1:
                    generalbalance = 0
                    the_loan.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            the_loan.balance = generalbalance
            the_loan.save()

            expectedinterest = 0
            # while date1 < date2:
            while m <= duration:
                sfine = 0
                sfines = 0
                if m == nextschedule or (
                    m == duration and paidschedules == duration
                ):
                    isnext = 1

                    spaid = round(nextbal, decimals)
                    sbalance = round(nextintallment, decimals)

                elif m < nextschedule:
                    isnext = 0
                    spaid = round(payable, decimals)
                    sbalance = 0

                else:
                    isnext = 2
                    spaid = 0
                    sbalance = round(payable, decimals)

                days.append(date1.strftime("%Y-%m-%d"))

                # print(nowdate)
                # print(date1)
                # if date1 < nowdate and isnext > 0:
                #     for loanfine in loanfines:
                #         fineamount = loanfine.general_charge.amount
                #         if loanfine.general_charge.is_percentage == True:
                #             sfines = (fineamount / 100) * payable
                #         else:
                #             sfines = fineamount

                #         sfine = float(sfine) + float(sfines)
                # else:
                #     sfine = 0
                sfine = 0

                sfine = round(sfine, decimals)

                interestperschedue = rbalance * interest
                interestperschedue = interestperschedue

                expectedinterest = expectedinterest + interestperschedue
                if interest > 0:
                    rbalance = principal * (
                        (pow((1 + interest), duration) - pow((1 + interest), m))
                        / (pow((1 + interest), duration) - 1)
                    )
                else:
                    rbalance = rbalance - payable
                if intpaid == m or intpaid > m:
                    actualinterest = 0

                else:
                    actualinterest = interestperschedue

                rprincipal = payable - interestperschedue
                rprincipal = rprincipal

                rbalance = rbalance

                pbalance = pbalance - rprincipal
                if spaid > 0:
                    cumrative_payments = cumrative_payments + spaid

                else:
                    cumrative_payments = 0

                loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                loan_dict[rprincipal] = rprincipal
                loan_dict[rbalance] = rbalance
                loan_dict[isnext] = isnext
                loan_dict[interestperschedue] = interestperschedue
                loan_dict[spaid] = spaid
                loan_dict[sbalance] = sbalance
                loan_dict[actualinterest] = actualinterest

                if float(total_principal_paid) > float(rprincipal):
                    current_principal_paid = rprincipal
                    current_principal_bal = 0
                else:
                    current_principal_paid = total_principal_paid
                    current_principal_bal = float(rprincipal) - current_principal_paid

                total_principal_paid = total_principal_paid - current_principal_paid


                data.append(
                    {
                        'schedule_date':loan_dict[in_date],
                        'total_paid': round(spaid, decimals),
                        'schedule_balance':round(sbalance, decimals),
                        'principal_balance':round(pbalance, decimals),
                        'installment':round(payable, decimals),
                        'principal_per_schedule':round(rprincipal, decimals),
                        'interestperschedue':round(interestperschedue, decimals),
                        'current_principal_paid': current_principal_paid,
                        'current_principal_bal': current_principal_bal
                    }
                )
                date1 = sch_date + m * to_add
                m = m + 1
                sfine = 0

                # date1 = date1 + to_add

                # //principal = rprincipal

        if the_loan.sub_intervals == True:
            totalinterest = round(totalinterest, decimals)
            totalpayable = approved_amount + totalinterest
        else:
            totalinterest = round(totalpayable - principal, decimals)
        
        ## --original
        # generalbalance = (totalpayable + totaladjustments - paidamount) - (
        #     adjustment_down - adjustment_added
        # )
        ## -- New
        generalbalance = (totalpayable - paidamount) 

        
        try:
            if generalbalance == 0 or generalbalance < 1:
                generalbalance = 0
                the_loan.loan_status = 4

        except:
            pass
        generalbalance = round(generalbalance, decimals)
        the_loan.balance = generalbalance
        the_loan.save()

        #
        totalpayable = round(totalpayable, decimals)
    
    #final schedules
    return data


def determine_principa_and_interest_in_arrears(schedules, principal_paid, interest_paid):
    principal_in_arrears = 0
    interest_in_arrears = 0
    current_date = datetime.now().date()
    for schedule in schedules:
        # get the schedule balance
        schedule_balance = float(schedule['schedule_balance'])
        sch_principal = float(schedule['principal_per_schedule'])
        sch_interest = float(schedule['interestperschedue'])
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()

        if schedule_balance == 0:
            if principal_paid >= sch_principal and principal_paid > 0:
                principal_paid = principal_paid - sch_principal
            else:
                principal_paid = 0
            if interest_paid >= sch_interest and interest_paid > 0:
                interest_paid = interest_paid - sch_interest
            else:
                interest_paid = 0
        else:
            if schedule_date < current_date: # this balance is in arrears
                if schedule_balance == float(schedule['installment']):
                    principal_in_arrears = principal_in_arrears + sch_principal
                    interest_in_arrears = interest_in_arrears + sch_interest
                    if principal_paid >= sch_principal and principal_paid > 0:
                        principal_paid=principal_paid - sch_principal
                    else:
                        principal_paid = 0
                    if interest_paid >= sch_interest and interest_paid > 0:
                        interest_paid=interest_paid-sch_interest
                    else:
                        interest_paid = 0
                else:
                    principal_in_arrears = principal_in_arrears + (sch_principal-principal_paid)
                    interest_in_arrears = interest_in_arrears + (sch_interest-interest_paid)
                    if principal_paid >= sch_principal and principal_paid > 0:
                        principal_paid = principal_paid - sch_principal
                    else:
                        principal_paid = 0
                    if interest_paid >= sch_interest and interest_paid > 0:
                        interest_paid = interest_paid - sch_interest
                    else:
                        interest_paid = 0
                        # Kaweesi
                        # Fred
            else:
                break
    return {
        'principal_in_arrears': principal_in_arrears,
        'interest_in_arrears': interest_in_arrears
    }


#NOTE: the_loan is an obj for Loans model
def get_all_loan_details(the_loan):
    formula = the_loan.loan_type.formula
    approved_amount = the_loan.amount_approved

    #total amount paid
    totals_paid = get_loan_amounts_paid(the_loan)
    total_charges = get_total_charges(the_loan)
    #determine the principal for the loan
    given_principal = determine_loan_principal(the_loan)
    disbursed_amt = determine_disbursed_amount(the_loan)
    
    # the interval
    loan_interval = get_loan_interval(the_loan)
    # the formulae
    formula = the_loan.loan_type.formula
    # interest size
    interest_size = determine_interest_percentage(the_loan, formula, loan_interval)
    #Duration sizes
    duration_sizes = determine_duration_sizes(the_loan, loan_interval)
    to_add = duration_sizes['to_add'],
    all_duration = duration_sizes['all_duration']
    if the_loan.rate_type == 1:
        the_schedules = flat_rate_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration)
    elif the_loan.rate_type == 2:
        the_schedules = reducing_balance_schedules(the_loan, to_add, interest_size, totals_paid, given_principal, all_duration)
    else:
        the_schedules = []

    the_schedules = adjust_schedule_date_loan_summary(the_schedules, the_loan)

    # print('-- THE SCHEDULES --', the_schedules)
    
    schedules_df = pd.DataFrame(the_schedules)
    schedules_list = schedules_df.to_dict(orient='records')
    total_interest_required = schedules_df['interestperschedue'].sum()

    decimals = 2

    if the_loan.applicant is not None:
        if the_loan.applicant.biodata is not None:
            the_name = the_loan.applicant.biodata.name
        else:
            the_name = the_loan.applicant.name
    else:
        the_name = ''

    # get the principal at risk -ARREARS DATA
    arrears_data = determine_principa_and_interest_in_arrears(the_schedules,
                                                              round(totals_paid['total_principal'], decimals),
                                                              round(totals_paid['total_interest'], decimals))

    return{
        'id': str(the_loan.id),
        'loan_number': str(the_loan.loan_number),
        'name': the_name,
        'schedule_start': str(the_loan.schedule_start),
        'approved_principal': round(the_loan.amount_approved, decimals),
        'principal_amt': round(given_principal, decimals),
        'disbursed_amount': round(disbursed_amt, decimals),
        'interest_required': round(total_interest_required, decimals),
        'loan_payable': round(total_interest_required + the_loan.amount_approved, decimals),
        'principal_paid': round(totals_paid['total_principal'], decimals),
        'interest_paid': round(totals_paid['total_interest'], decimals),
        'principal_balance': round((given_principal - totals_paid['total_principal']), decimals),
        'interest_balance': round((total_interest_required - totals_paid['total_interest']), decimals),
        'loan_balance': round(((total_interest_required + the_loan.amount_approved) - (totals_paid['total_principal']+totals_paid['total_interest'])), decimals),
        'is_error': 'no',
        'error': '',
        'ammotization': schedules_list,
        'loan_officer_names': the_loan.officer.biodata.name if the_loan.officer is not None else '',
        'loan_officer_id': the_loan.officer.id if the_loan.officer is not None else '',
        'contact': str(the_loan.applicant.biodata.contact),
        'principal_in_arrears': arrears_data['principal_in_arrears'],
        'interest_in_arrears': arrears_data['interest_in_arrears']
    }


def update_loan_summary_details(the_loan):
    if the_loan.loan_status >=3:
        try:
            the_details = get_all_loan_details(the_loan)
            Loans.objects.filter(id=the_loan.id).update(
                loan_summary_details=json.dumps(the_details),
                balance=float(the_details['loan_balance']),
                principal_balance=float(the_details['principal_balance']),
                interest_balance=float(the_details['interest_balance']),
            )
            
        except Exception as e:
            # import traceback
            # print("The line where the error occurred:")
            # traceback.print_exc()
            
            Loans.objects.filter(id=the_loan.id).update(
                loan_summary_details=json.dumps({
                    'id': str(the_loan.id),
                    'name': '',
                    'schedule_start': '',
                    'approved_principal': 0,
                    'principal_amt': 0,
                    'disbursed_amount': 0,
                    'interest_required': 0,
                    'loan_payable': 0,
                    'principal_paid': 0,
                    'interest_paid': 0,
                    'principal_balance': 0,
                    'interest_balance': 0,
                    'loan_balance': 0,
                    'is_error': 'yes',
                    'error': str(e),
                    'ammotization': [],
                    'loan_officer_names': '',
                    'loan_officer_id': '',
                    'contact': '',
                })
            )
    else:
        Loans.objects.filter(id=the_loan.id).update(
            loan_summary_details=json.dumps({
                'id': str(the_loan.id),
                'name': '',
                'schedule_start': '',
                'approved_principal': 0,
                'principal_amt': 0,
                'disbursed_amount': 0,
                'interest_required': 0,
                'loan_payable': 0,
                'principal_paid': 0,
                'interest_paid': 0,
                'principal_balance': 0,
                'interest_balance': 0,
                'loan_balance': 0,
                'is_error': 'yes',
                'error': '',
                'ammotization': [],
                'loan_officer_names': '',
                'loan_officer_id': '',
                'contact': '',
            })
        )


def calculate_days_difference(date):
    today = pd.Timestamp.now().normalize()
    date = pd.Timestamp(date)
    return (today - date).days

def determine_paginator_numbers(page):
    the_start_number = ((page * 10) - 10)
    the_end_number = the_start_number + 10
    return{
        'the_start_number':the_start_number,
        'the_end_number': the_end_number
    }

def calculate_amount_due(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    amount_due = 0
    last_date_found = None
    current_date = datetime.now().date()
    total_days_overdue = 0
    for schedule in schedules:
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due += schedule['schedule_balance']
            last_date_found = schedule_date
            total_days_overdue += (current_date - last_date_found).days
    return amount_due, last_date_found, total_days_overdue


def calculate_amount_due_PAR(row):
    """
    NOTE : The amount due is principal due
    """
    schedules = row['ammotization']
    amount_due = 0
    last_date_found = None
    current_date = datetime.now().date()
    total_days_overdue = 0
    for schedule in schedules:
        try:
            schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        except Exception as e:
            schedule_date = datetime.today().date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due += schedule['current_principal_bal']
            last_date_found = schedule_date
            total_days_overdue += (current_date - last_date_found).days
    return amount_due, last_date_found, total_days_overdue





def calculate_amount_due_schedules(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    current_date = datetime.now().date()
    overdue_schedules = []
    for schedule in schedules:
        schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
        if schedule_date < current_date and schedule['schedule_balance'] > 0:
            amount_due = schedule['schedule_balance']
            last_date_found = schedule_date
            total_days_overdue = (current_date - last_date_found).days
            overdue_schedules.append({
                'payment_date': last_date_found,
                'days_overdue': total_days_overdue,
                'expected_amount': amount_due
            })

    return overdue_schedules


def get_aging_report_data(request):
    #determine the pagination range
    # paginator_numbers = determine_paginator_numbers(page)
    # the_start_number = paginator_numbers['the_start_number']
    # the_end_number = paginator_numbers['the_end_number']

    all_loans = list(Loans.objects.filter(loan_status=3, branch_id=branchdata(request)).values_list('loan_summary_details', flat=True))
    df = pd.DataFrame(eval(item) for item in all_loans)
    df = df[df['is_error'] == 'no']

    #INDIVIDUAL ARREARS
    df_individual_arrears = copy.deepcopy(df)
    df_individual_arrears['amount_due'], df_individual_arrears['last_date_found'], df_individual_arrears['total_days_overdue'] = zip(*df_individual_arrears.apply(calculate_amount_due, axis=1))
    # print(df_individual_arrears)

    #OVERDUE PAYMENTS
    df_overdue_payments = copy.deepcopy(df)
    df_overdue_payments['overdue_payments'] = df.apply(calculate_amount_due_schedules, axis=1)
    # print(df_overdue_payments)


    #CREATE DAYS CATEGORIES DATA
    df['days_difference'] = df['schedule_start'].apply(calculate_days_difference)
    # # Define the bins
    bins = [-1, 30, 60, 90, float('inf')]  # 0-30, 31-60, 61-90, and more than 90 days

    # # Create a new column 'Days_Group' to represent the bins
    df['Days_Group'] = pd.cut(df['days_difference'], bins=bins, labels=['0-30', '31-60', '61-90', '90+'])
    # # Group the loans based on the bins
    grouped_loans = df.groupby('Days_Group')

    all_loans = {}
    for group, group_data in grouped_loans:
        #the key
        if '+' in group:
            the_key = f"the_{group.replace('+', '_')}"
        else:
            the_key = f"the_{group.replace('-', '_')}"


        all_loans[the_key] = group_data['loan_balance'].sum()

    for key in all_loans.keys():
        print(key)

    return {
        'df_individual_arrears': df_individual_arrears,
        'df_overdue_payments': df_overdue_payments,
        'all_loans': all_loans
    }


def generate_custom_context(the_loan, request):
    """
    the_loan: model object for loans model
    """
    # determine the savings required
    percentage = 0
    mandatory_saving = False
    if request.user.staff.biodata.business.custom_modules.filter(name='loan percent saving').exists():
        if the_loan.savings_percentage_balance is not None:
            percentage = float(the_loan.savings_percentage_balance)
        else:
            percentage = 0
        mandatory_saving = True

    #amount needed
    if the_loan.loan_status >=2:
        # if approved use the approved amount
        amt_needed = round((percentage*the_loan.amount_approved)/100, 2)
    else:
        amt_needed = round((percentage*the_loan.amount_requested)/100, 2)

    return{
        'allow_mandatory_saving': mandatory_saving,
        'saving_needed': amt_needed
    }


# -------------- aging report funcs -----------------------------------
def calculate_amount_due_v2(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    amount_due = 0
    last_date_found = None
    current_date = datetime.now().date()
    total_days_overdue = 0
    for schedule in schedules:
        try:
            schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
            if schedule_date < current_date and schedule['schedule_balance'] > 0:
                amount_due += schedule['schedule_balance']
                last_date_found = schedule_date
                total_days_overdue += (current_date - last_date_found).days
        except:
            amount_due += schedule['schedule_balance']
            last_date_found = current_date
            total_days_overdue = 1
    return amount_due, last_date_found, total_days_overdue

def calculate_amount_due_schedules_v2(row):
    # schedules = ast.literal_eval(row['ammotization'])
    schedules = row['ammotization']
    current_date = datetime.now().date()
    overdue_schedules = []
    for schedule in schedules:
        try:
            schedule_date = datetime.strptime(schedule['schedule_date'], '%Y-%m-%d').date()
            if schedule_date < current_date and schedule['schedule_balance'] > 0:
                amount_due = schedule['schedule_balance']
                last_date_found = schedule_date
                total_days_overdue = (current_date - last_date_found).days
                overdue_schedules.append({
                    'payment_date': last_date_found,
                    'days_overdue': total_days_overdue,
                    'expected_amount': amount_due
                })
        except Exception as e:
            overdue_schedules.append({
                'payment_date': current_date,
                'days_overdue': 1,
                'expected_amount': schedule['schedule_balance']
            })

    return overdue_schedules

def get_aging_report_data_v2(request, member, officer):
    business_context = get_business_loans_context_data(request)
    # business_filter = business_context['business_filter']
    # determine the pagination range
    # paginator_numbers = determine_paginator_numbers(page)
    # the_start_number = paginator_numbers['the_start_number']
    # the_end_number = paginator_numbers['the_end_number']
    # print('------ THE START----------')

    all_loans = Loans.objects.filter(loan_status=3, branch__business_id__in=business_context['data_context'])
    all_loans = all_loans.exclude(loan_summary_details=None)
    all_loans = all_loans.exclude(loan_summary_details='')
    if member is not None:
        all_loans = all_loans.filter(applicant_id=member)
    if officer is not None:
        all_loans = all_loans.filter(officer_id=officer)
    all_loans = list(all_loans.values_list('loan_summary_details', flat=True))
    df = pd.DataFrame(eval(item) for item in all_loans)
    if not df.empty:
        df = df[df['is_error'] == 'no']

        # INDIVIDUAL ARREARS
        df_individual_arrears = copy.deepcopy(df)
        df_individual_arrears['amount_due'], df_individual_arrears['last_date_found'], df_individual_arrears[
            'total_days_overdue'] = zip(*df_individual_arrears.apply(calculate_amount_due_v2, axis=1))
        # print(df_individual_arrears)

        # OVERDUE PAYMENTS
        df_overdue_payments = copy.deepcopy(df)
        df_overdue_payments['overdue_payments'] = df.apply(calculate_amount_due_schedules_v2, axis=1)
        # print(df_overdue_payments)
        # print(df_overdue_payments['overdue_payments'])

        # CREATE DAYS CATEGORIES DATA
        ### ------- original code basing on schedule start date and amount given ----------------------
        """
        df['days_difference'] = df['schedule_start'].apply(calculate_days_difference)
        # # Define the bins
        bins = [-1, 30, 60, 90, float('inf')]  # 0-30, 31-60, 61-90, and more than 90 days

        # # Create a new column 'Days_Group' to represent the bins
        df['Days_Group'] = pd.cut(df['days_difference'], bins=bins, labels=['0-30', '31-60', '61-90', '90+'])
        # # Group the loans based on the bins
        grouped_loans = df.groupby('Days_Group')
        """
        ### ------- original code basing on schedule start date and amount given ----------------------
        df_categories = pd.json_normalize(df_overdue_payments['overdue_payments'].explode())
        bins = [-1, 30, 60, 90, float('inf')]  # 0-30, 31-60, 61-90, and more than 90 days

        # # Create a new column 'Days_Group' to represent the bins
        df_categories['Days_Group'] = pd.cut(df_categories['days_overdue'], bins=bins,
                                             labels=['0-30', '31-60', '61-90', '90+'])
        # print(df_categories)
        # # Group the loans based on the bins
        grouped_loans = df_categories.groupby('Days_Group')

        all_loans = {}
        for group, group_data in grouped_loans:
            # the key
            if '+' in group:
                the_key = f"the_{group.replace('+', '_')}"
            else:
                the_key = f"the_{group.replace('-', '_')}"

            all_loans[the_key] = group_data['expected_amount'].sum()

        return {
            'df_individual_arrears': df_individual_arrears,
            'df_overdue_payments': df_overdue_payments,
            'all_loans': all_loans
        }

    else:
        return {
            'df_individual_arrears': 'empty',
            'df_overdue_payments': 'empty',
            'all_loans': 'empty'
        }
    

def update_loan_balance_field(the_loan_id, the_business_id, the_branch_id):
    loanid = the_loan_id
    loansid = int(loanid)
    today = datetime.today().date()
    nowdate = today.strftime("%Y-%m-%d")
    # this_business = Business.objects.filter(id=businessdata(request)).first()
    

    try:
        detail = Loans.objects.raw(
            "SELECT l.*, b.the_account_id as accountid, b.members_id as memberid, a.acc_number, m.biodata_id, m.id, c.name AS member_name, year(l.approved_on) as yapp, month(l.approved_on) as appmonth, day(l.approved_on) as appday FROM account_broker b, member_accounts a, sacco_member m, biodata c, loans l where b.the_account_id = a.id and b.business_id = %s and b.members_id = m.id and m.biodata_id = c.id and l.account_id = a.id and l.branch_id = %s and l.id=%s"
            % (the_business_id, the_branch_id, the_loan_id)
        )[0]

    
    except AttributeError as _e:
        detail = None
    except (Exception,) as e:
        print(e)
        detail = None


    formula = detail.loan_type.formula
    approved_amount = detail.amount_approved

    try:
        paid = Transactions.objects.raw(
            "SELECT SUM(reporting_amount) as tpaid,id from transactions where (transaction_type='Loan repayment' OR transaction_type='Loan interest') AND loan_id= %s "
            % (loanid)
        )[0]
        paidamount = paid.tpaid

    except:
        paidamount = 0

    #    ========================CLEARED INTERESTS============================================

    interestspaid = Transactions.objects.filter(
        loan_id=loanid,
        transaction_type="Loan interest",
        branch__business_id=the_business_id,
    )
    intpaid = interestspaid.count()

    loanr = Account.objects.filter(
        name="Loan receivables", business=the_business_id
    )[0]

    # ===========================================================================================
    # print('ADJUSTMENT IS ',totaladjustments)
    try:
        loan_setings = LoanSettings.objects.filter(business=businessdata(request))[
            0
        ]
        decimals = loan_setings.decimals
        
    except Exception as gex:
        decimals = 0

    # ======================SEND TO THE VIEW CALCULATED CHARGES======================================

    totalcharges = 0

    if int(detail.loan_status) > 1:
        actualchargesx = detail.charges
        try:
            actualcharges = json.loads(actualchargesx)
            for chg in actualcharges:
                chargeamount = chg["amount"]
                totalcharges = totalcharges + chargeamount

        except:
            totalcharges = 0

    # ============ GET CHARGES IF THE CHARGES ARE STILL IN APPLICATION STAGE ====================
    else:
        charges = ApplicationAccountOrLoanType.objects.filter(
            loan_type=detail.loan_type,
            general_charge__status=1,
            general_charge__application="l",
        )

        actualcharges = []
        for charge in charges:
            ispercentage = charge.general_charge.is_percentage
            if ispercentage == 1:
                if detail.loan_status < 2:
                    chargeamount = (
                                            charge.general_charge.amount * detail.amount_requested
                                    ) / 100
                else:
                    chargeamount = (
                                            charge.general_charge.amount * detail.amount_approved
                                    ) / 100

            else:
                chargeamount = charge.general_charge.amount

            actualcharges.append(
                {"name": charge.general_charge.charge, "amount": chargeamount}
            )

            totalcharges = totalcharges + chargeamount

    if detail.is_topup == True:
        oldloan = LoanTopups.objects.filter(topup_loan_id=loanid).first()

        oldloanid = oldloan.closed_loan.id

        # =============================GET PRINCIPAL BALANCE=========================
        recevables_account = Account.objects.filter(
            name="Loan Receivables", business=the_business_id
        )[0]

        try:
            try:
                #     ===========IF MEMBER HAS MADE SOME PAYMENT==================
                if detail.loan_status > 2:
                    lcredits = Transactions.objects.filter(
                        Q(loan_id=oldloanid, account_cr=recevables_account.id),
                        ~Q(transaction_type="Closing Loan"),
                    ).aggregate(principlecredits=Sum("reporting_amount"))[
                        "principlecredits"
                    ]
                else:
                    lcredits = Transactions.objects.filter(
                        loan_id=oldloanid, account_cr=recevables_account.id
                    ).aggregate(principlecredits=Sum("reporting_amount"))[
                        "principlecredits"
                    ]
            except:
                lcredits = 0

            ldebits = Transactions.objects.filter(
                loan_id=oldloanid, account_dr=recevables_account.id
            ).aggregate(principledebits=Sum("reporting_amount"))["principledebits"]

            if lcredits is None:
                oldbalance = ldebits

            else:
                oldbalance = float(ldebits) - float(lcredits)
            oldbalance = float(oldbalance)

        except Exception as ex:
            print("Error is ", str(ex))

            oldbalance = 0

        totalpold = Transactions.objects.filter(
            loan_id=oldloanid, transaction_type="Loan repayment"
        ).aggregate(totalpaidprincipalold=Sum("reporting_amount"))

        totalpaidprincipalold = totalpold["totalpaidprincipalold"]
        try:
            totalpaidprincipalold = float(totalpaidprincipalold)
        except:
            totalpaidprincipalold = 0

    if detail.loan_status < 2:
        if detail.charges_paid == False:
            if detail.is_topup == True:
                disbusable = approved_amount - (totalcharges)
            else:
                disbusable = approved_amount
        else:
            if detail.is_topup == True:
                disbusable = approved_amount - (totalcharges)
            else:
                disbusable = approved_amount - totalcharges
    else:
        if not detail.charges_paid:
            if detail.is_topup:
                disbusable = approved_amount - (oldbalance)
            else:
                disbusable = approved_amount
        else:
            if detail.is_topup == True:
                disbusable = approved_amount - (oldbalance)
            else:
                disbusable = approved_amount

    disbusable = round(disbusable, decimals)

    docs = LoanUpload.objects.filter(loan=loanid)


    # ==================GET INTEREST IN RELATION TO SETTINGS=====================
    # get the payment interval and if None add it the loan obj
    if detail.interval is not None:
        typeinterval = detail.interval
    else:
        typeinterval = detail.loan_type.interval
        detail.interval = typeinterval
        detail.save()

    interest = (detail.rate / 100) / 12

    if detail.loan_status > 2:
        maccount = detail.accountid
        try:
            paidamount = round(paidamount, decimals)

        except:
            paidamount = 0

        duration = detail.approved_duration
        appdate = detail.schedule_start

        principal = detail.amount_approved
        # print('PRINCIPAL ONE', principal)

        loanacct = Account.objects.filter(
            name="Loan Receivables", business=the_business_id
        ).first()

        # ==================TOTAL PRINCIPAL DEBIT===============================

        totaldebit = Transactions.objects.filter(
            Q(loan_id=loanid, account_dr_id=loanacct.id),
            ~Q(transaction_type="Principal Adjustment"),
        ).aggregate(totalpdebit=Sum("reporting_amount"))

        # incase the is removal of an extra charge (this is a fix for the extra charge that was being added to loan amt ap
        # approved due to 'added to principal'
        extra_charge_removed = Transactions.objects.filter(
            loan_id=loanid, transaction_type="Remove extra loan charge"
        )
        if extra_charge_removed:
            # print("there was an extra charge removed")
            extra_charge_removed = extra_charge_removed.aggregate(
                ex_charge=Sum("reporting_amount")
            )["ex_charge"]
        else:
            extra_charge_removed = 0

        # print(f'principal first:{principal}')
        # print(f'totalpdebit:{totaldebit["totalpdebit"]} add:{adjustment_down} adu{adjustment_added} ext:{extra_charge_removed} ta:{totaladjustments}')
        totaldebit = 0 if totaldebit['totalpdebit'] is None else totaldebit['totalpdebit']
        # print('ret', totaldebit)
        principal = (
                float(totaldebit) - extra_charge_removed
        )
        # print(f'principal second:{principal}')
        approved_amount = principal

        principal = float(principal)
        approved_amount = float(approved_amount)

        if formula == 5:
            interest = detail.rate / 100

        if formula == 1:  # per annum
            if typeinterval == 3:  # months
                interest = (detail.rate / 100) / 12

            if typeinterval == 0:  # Days
                interest = (detail.rate / 100) / 365

            if typeinterval == 1:  # weeks
                interest = (detail.rate / 100) / 52

            if typeinterval == 2:  # Fortnight
                interest = (detail.rate / 100) / 26

            if typeinterval == 4:
                interest = detail.rate / 100

        if formula == 2:  # per month
            if typeinterval == 3:
                interest = detail.rate / 100

            if typeinterval == 0:
                interest = (detail.rate / 100) / 30

            if typeinterval == 1:  # week - schedule
                interest = (detail.rate / 100) / 4

            if typeinterval == 2:
                interest = (detail.rate / 100) / 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 12

        if formula == 3:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 4

            if typeinterval == 0:
                interest = (detail.rate / 100) * 7

            if typeinterval == 1:
                interest = detail.rate / 100

            if typeinterval == 2:
                interest = (detail.rate / 100) * 2

            if typeinterval == 4:
                interest = (detail.rate / 100) * 52

        if formula == 4:
            if typeinterval == 3:
                interest = (detail.rate / 100) * 30

            if typeinterval == 0:
                interest = detail.rate / 100

            if typeinterval == 1:
                interest = (detail.rate / 100) * 7

            if typeinterval == 2:
                interest = (detail.rate / 100) * 14

            if typeinterval == 4:
                interest = (detail.rate / 100) * 365

        # ===================GET LOAN REPAYMENTS========================================

        # =====================IF INTERVAL IS MONTHLY =========================
        if typeinterval == 3:
            to_add = relativedelta(months=1)
            try:
                all_duration = relativedelta(months=duration)
            except Exception as exp:
                print(str(exp))

        # =====================IF INTERVAL IS DAILY =========================

        if typeinterval == 0:
            to_add = relativedelta(days=1)
            all_duration = relativedelta(days=duration)

        # =====================IF INTERVAL IS WEEKLY =========================

        if typeinterval == 1:
            to_add = relativedelta(weeks=1)
            all_duration = relativedelta(weeks=duration)

        # =====================IF INTERVAL IS BI-WEEKLY =========================

        if typeinterval == 2:
            to_add = relativedelta(weeks=2)
            all_duration = relativedelta(weeks=duration * 2)

        # =====================IF INTERVAL IS YEARLY =========================

        if typeinterval == 4:
            to_add = relativedelta(years=1)
            all_duration = relativedelta(years=int(duration))

        # ================================DETERMINING THE FINES AND ON WHICH SCHEDULES==========================
        nowdate = datetime.today().date()

        # get loan fines

        loanfines = ApplicationAccountOrLoanType.objects.filter(
            loan_type_id=detail.loan_type.id,
            general_charge__application="o",
            general_charge__is_fine=True,
        )

        # loanfines=[]

        sfine = 0
        fine = 0

        recevables_account = Account.objects.filter(
            name="Loan Receivables", business=the_business_id
        )[0]

        try:
            credits = Transactions.objects.filter(
                Q(loan_id=loanid, account_cr=recevables_account.id),
                ~Q(transaction_type="Closing Loan"),
            ).aggregate(principlecredits=Sum("reporting_amount"))[
                "principlecredits"
            ]

            debits = Transactions.objects.filter(
                loan_id=loanid, account_dr=recevables_account.id
            ).aggregate(principledebits=Sum("reporting_amount"))["principledebits"]
            if credits is None:
                principalbal = debits
            else:
                principalbal = float(debits) - float(credits)
            # print('CREDITS:',credits, "debits:", debits)
            principalbal = float(principalbal)
            # print("PRINCIPAL FOUR", principal)
        except Exception as ex:
            print("Error is ", str(ex))
            principalbal = 0
        nextinterest = 0
        # =======================IF RATE TYPE IS FLAT============================
        cumrative_payments = 0
        if detail.rate_type == 1:
            days = []
            schedules = approved_amount / duration
            interestperschedue = approved_amount * interest
            payable = interestperschedue + schedules

            startyear = detail.yapp
            startmonth = detail.appmonth + 1
            startday = detail.appday

            # ========================================GET PAID SCHEDULES=========================

            paidschedules = paidamount / payable
            paidschedules = floor(paidschedules)

            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal

            # print('NeXT INSTALL ', nextintallment, 'bal ', nextbal)
            if 1 > nextintallment > 0:
                nextintallment = payable + nextintallment
                nextschedule = paidschedules + 2
            else:
                nextschedule = paidschedules + 1

            edate = appdate + to_add
            # print(appdate)
            date1 = edate
            totalpayable = payable * duration

            totalinterest = totalpayable - principal

            totalinterest = round(totalinterest, decimals)

            totalpayable = round(totalpayable, decimals)

            rbalance = totalpayable

            date2 = date1 + all_duration
            m = 1

            try:
                principalbalance = principal

                sch_date = date1
                # while date1 < date2:
                while m <= duration:
                    pbalance = 0

                    if intpaid == m or intpaid > m:
                        actualinterest = 0
                    else:
                        actualinterest = interestperschedue

                    rbalance = rbalance - payable
                    rbalance = rbalance
                    if m == nextschedule:
                        isnext = 1
                        spaid = nextbal
                        sbalance = nextintallment

                    elif m < nextschedule:
                        isnext = 0
                        spaid = payable
                        sbalance = 0

                    else:
                        isnext = 2
                        spaid = 0
                        sbalance = payable

                    if date1 < nowdate and isnext > 0:
                        for loanfine in loanfines:
                            fineamount = loanfine.general_charge.amount
                            if loanfine.general_charge.is_percentage == True:
                                sfines = (fineamount / 100) * payable
                            else:
                                sfines = fineamount

                            sfine = float(sfine) + float(sfines)
                    else:
                        sfine = 0

                    sfine = round(sfine, decimals)

                    # print("S FINE", sfine)

                    # print("PRINCIPAL BALANCE BEFORE", principalbalance)

                    principalbalance = principalbalance - schedules

                    # print("PRINCIPAL BALANCE AFTER", principalbalance)

                    days.append(
                        [
                            date1.strftime("%Y-%m-%d"),
                            isnext,
                            round(spaid, decimals),
                            round(sbalance, decimals),
                            round(rbalance, decimals),
                            round(actualinterest, decimals),
                            sfine,
                            round(principalbalance, decimals),
                            round(payable, decimals),
                        ]
                    )

                    payable = round(payable, decimals)
                    schedules = round(schedules, decimals)
                    interestperschedue = round(interestperschedue, decimals)
                    if date1.weekday() == 5:
                        date1 = date1 + to_add + relativedelta(days=1)
                        date2 = date2 + relativedelta(days=1)

                    else:
                        date1 = date1 + to_add

                    sfine = 0

                    m = m + 1
            except Exception as erp:
                print("ERROR %", str(erp))

            generalbalance: int | Any = (totalpayable - paidamount) 
            try:
                if generalbalance == 0 or generalbalance < 1:
                    generalbalance = 0
                    detail.loan_status = 4
            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

        # =============================================IF THE RATE TYPE IS REDUCING================================
        if detail.rate_type == 2:
            in_date = ""
            loan_dict = {}
            data = []
            days = []
            # print('apt', appdate)
            # print('to_add', to_add)
            if appdate:
                edate = appdate + to_add
            else:
                edate = to_add
            date1 = edate
            principals = 0
            date2 = date1 + all_duration
            runningbal = approved_amount
            if interest > 0:
                numilator = (
                        principal
                        * interest
                        * (
                                (pow((1 + interest), duration))
                                / (pow((1 + interest), duration) - 1)
                        )
                )
            else:
                numilator = principal / duration
            payable = numilator

            totalpayable = payable * duration

            totalpayable = totalpayable

            rprincipal = 0
            rbalance = principal
            # ========================================GET PAID SCHEDULES=========================

            try:
                paidschedules = paidamount / payable
            except ZeroDivisionError:
                paidschedules = 0
            paidschedules = floor(paidschedules)

            # print('PAID SCHEDULES ARE ', paidschedules, 'Paid Is ', paidamount, 'Payabale is ', payable)

            # ====================================Balance for the next schedule=======================
            nextbal = paidamount - (payable * paidschedules)
            nextintallment = payable - nextbal
            # print('NeXT INSTALL ',nextintallment, 'bal ',nextbal )
            if nextintallment < 1 and nextintallment > 0:
                nextintallment = payable + nextintallment
                nextschedule = paidschedules + 2
            else:
                nextschedule = paidschedules + 1
            m = 1
            isnext = 0
            sfine = 0
            sch_date = date1

            if detail.sub_intervals == True:
                if detail.interval == 4:
                    pricipalperschdule = principal / duration
                    paymentperiod = []
                    remainingprincipal = principal
                    rem_principal = principal

                    # gettotalinterest
                    totalinterest = 0
                    for a in range(0, int(duration)):
                        perinterest = rem_principal * interest
                        yearlypayable = rem_principal + perinterest
                        rem_principal = rem_principal - pricipalperschdule
                        totalinterest = totalinterest + perinterest

                    pbalance = principal
                    sch_date = date1
                    # while date1 < date2:
                    while m <= duration:
                        date3 = date1 - relativedelta(years=1)
                        runningbal = principal + totalinterest
                        for a in range(0, int(duration)):
                            generalint = remainingprincipal * interest
                            generalpayable = pricipalperschdule + generalint
                            interestperschedue = generalint / 12
                            interestperschedue = round(interestperschedue, 2)
                            payable = generalpayable / 12
                            rprincipal = payable - interestperschedue
                            # rprincipal = round(rprincipal, decimals)

                            paidschedules = paidamount / payable
                            paidschedules = floor(paidschedules)

                            for sched in range(0, 12):
                                nextbal = paidamount - (payable * paidschedules)
                                nextintallment = payable - nextbal
                                if nextintallment < 1 and nextintallment > 0:
                                    nextintallment = payable + nextintallment
                                    nextschedule = paidschedules + 2
                                else:
                                    nextschedule = paidschedules + 1

                                sfine = 0
                                sfines = 0
                                if m == nextschedule:
                                    isnext = 1
                                    if nextbal < 1:
                                        spaid = 0
                                    else:
                                        spaid = round(nextbal, decimals)
                                    sbalance = round(
                                        nextintallment , decimals
                                    )

                                elif m < nextschedule:
                                    isnext = 0
                                    spaid = round(payable, decimals)
                                    sbalance = 0

                                else:
                                    isnext = 2
                                    spaid = 0
                                    sbalance = round(payable, decimals)

                                days.append(date1.strftime("%Y-%m-%d"))

                                if date1 < nowdate and isnext > 0:
                                    for loanfine in loanfines:
                                        fineamount = loanfine.general_charge.amount
                                        if (
                                                loanfine.general_charge.is_percentage
                                                == True
                                        ):
                                            sfines = (fineamount / 100) * payable
                                        else:
                                            sfines = fineamount

                                        sfine = float(sfine) + float(sfines)
                                else:
                                    sfine = 0

                                sfine = round(sfine, decimals)

                                runningbal = runningbal - payable
                                rbalance = round(runningbal, decimals)

                                if intpaid == m or intpaid > m:
                                    actualinterest = 0

                                else:
                                    actualinterest = interestperschedue

                                pbalance = pbalance - rprincipal
                                if spaid > 1:
                                    cumrative_payments = cumrative_payments + spaid

                                else:
                                    cumrative_payments = 0

                                loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                                loan_dict[rprincipal] = rprincipal
                                loan_dict[rbalance] = rbalance
                                loan_dict[isnext] = isnext
                                loan_dict[interestperschedue] = interestperschedue
                                loan_dict[spaid] = spaid
                                loan_dict[sbalance] = sbalance
                                loan_dict[actualinterest] = actualinterest
                                data.append(
                                    [
                                        round(rprincipal, decimals),
                                        loan_dict[in_date],
                                        loan_dict[round(rbalance, decimals)],
                                        loan_dict[
                                            round(interestperschedue, decimals)
                                        ],
                                        loan_dict[round(isnext, decimals)],
                                        loan_dict[round(spaid, decimals)],
                                        loan_dict[round(sbalance, decimals)],
                                        loan_dict[actualinterest],
                                        sfine,
                                        round(payable, decimals),
                                        round(pbalance, decimals),
                                        round(cumrative_payments, decimals),
                                    ]
                                )

                                if date1.weekday() != 5:
                                    date1 = date1 + to_add
                                else:
                                    date1 = date1 + to_add + relativedelta(days=1)
                                    date2 = date2 + relativedelta(days=1)

                                # date1 = sch_date + m * to_add
                                date3 = sch_date + relativedelta(months=m)
                                m = m + 1

                                sfine = 0

                            remainingprincipal = (
                                    remainingprincipal - pricipalperschdule
                            )
                    generalbalance = (totalpayable)

                    try:
                        if generalbalance == 0 or generalbalance < 1:
                            generalbalance = 0
                            detail.loan_status = 4

                    except:
                        pass
                    generalbalance = round(generalbalance, decimals)
                    detail.balance = generalbalance
                    detail.save()

                # print('PRINCIPAL Five', principal)

                if detail.interval == 3:
                    # print('I AM IN THE MONTH')
                    pricipalperschdule = principal / duration
                    paymentperiod = []
                    remainingprincipal = principal
                    rem_principal = principal
                    segments = ceil(duration / 12)
                    actualyears = floor(duration / 12)
                    halfyear = duration - (actualyears * 12)

                    totalinterest = 0
                    for a in range(0, int(actualyears)):
                        perinterest = rem_principal * interest * 12
                        # print('CUMLATIVE INT',perinterest )
                        yearlypayable = rem_principal + perinterest
                        rem_principal = rem_principal - pricipalperschdule * 12
                        totalinterest = totalinterest + perinterest
                        paymentperiod.append(12)
                    # ====FOR THE BALANCE OF MONTH==========================

                    if halfyear > 0:
                        perinterest = rem_principal * interest * halfyear
                        totalinterest = totalinterest + perinterest
                        paymentperiod.append(halfyear)
                    # print('PERIODS ', halfyear)
                    pbalance = principal
                    date3 = date1
                    # print('runningbal ', runningbal)
                    # print('totalinterest ', totalinterest)
                    runningbal = principal + totalinterest
                    index = 0
                    for a in paymentperiod:
                        if a < 12:
                            generalint = remainingprincipal * interest
                        else:
                            generalint = remainingprincipal * interest * (a / 12)
                        generalpayable = pricipalperschdule + generalint
                        interestperschedue = generalint
                        interestperschedue = interestperschedue
                        payable = generalpayable
                        rprincipal = payable - interestperschedue

                        paidschedules = paidamount / payable
                        paidschedules = floor(paidschedules)

                        for sched in range(0, int(a)):
                            nextbal = paidamount - (payable * paidschedules)
                            nextintallment = payable - nextbal

                            if nextintallment < 1 and nextintallment > 0:
                                nextintallment = payable + nextintallment
                                nextschedule = paidschedules + 2
                            else:
                                nextschedule = paidschedules + 1

                            sfine = 0
                            sfines = 0
                            if m == nextschedule:
                                isnext = 1
                                if nextbal < 1:
                                    spaid = 0
                                else:
                                    spaid = nextbal
                                sbalance = nextintallment

                            elif m < nextschedule:
                                isnext = 0
                                spaid = payable
                                sbalance = 0

                            else:
                                isnext = 2
                                spaid = 0
                                sbalance = payable

                            days.append(date1.strftime("%Y-%m-%d"))

                            if date1 < nowdate and isnext > 0:
                                for loanfine in loanfines:
                                    fineamount = loanfine.general_charge.amount
                                    if (
                                            loanfine.general_charge.is_percentage
                                            == True
                                    ):
                                        sfines = (fineamount / 100) * payable
                                    else:
                                        sfines = fineamount

                                    sfine = float(sfine) + float(sfines)
                            else:
                                sfine = 0

                            sfine = round(sfine, decimals)

                            runningbal = runningbal - payable
                            rbalance = runningbal
                            if intpaid == m or intpaid > m:
                                actualinterest = 0

                            else:
                                actualinterest = interestperschedue

                            pbalance = pbalance - rprincipal
                            if spaid > 0:
                                cumrative_payments = cumrative_payments + spaid

                            else:
                                cumrative_payments = 0

                            loan_dict[in_date] = date3.strftime("%Y-%m-%d")
                            loan_dict[rprincipal] = rprincipal
                            loan_dict[rbalance] = rbalance
                            loan_dict[isnext] = isnext
                            loan_dict[interestperschedue] = interestperschedue
                            loan_dict[spaid] = spaid
                            loan_dict[sbalance] = sbalance
                            loan_dict[actualinterest] = actualinterest
                            if rbalance < 1:
                                rbalance = 0

                            if rprincipal < 1:
                                rprincipal = 0

                            if pbalance < 1:
                                pbalance = 0

                            data.append(
                                [
                                    round(rprincipal, decimals),
                                    loan_dict[in_date],
                                    round(rbalance, decimals),
                                    round(interestperschedue, decimals),
                                    loan_dict[round(isnext, decimals)],
                                    round(spaid, decimals),
                                    round(sbalance, decimals),
                                    round(actualinterest, decimals),
                                    sfine,
                                    round(payable, decimals),
                                    round(pbalance, decimals),
                                    round(cumrative_payments, decimals),
                                ]
                            )
                            date3 = sch_date + relativedelta(months=m)
                            date1 = sch_date + m * to_add
                            m = m + 1
                            sfine = 0
                            # date1 = date1 + to_add
                            # date1 = sch_date + m * to_add
                            # date3 = date3 + relativedelta(months=1)

                        index = index + 1
                        remainingprincipal = (
                                remainingprincipal - pricipalperschdule * 12
                        )

            else:
                pbalance = principal
                sch_date = date1

                generalbalance = (totalpayable - paidamount) 
                try:
                    if generalbalance == 0 or generalbalance < 1:
                        generalbalance = 0
                        detail.loan_status = 4

                except:
                    pass
                generalbalance = round(generalbalance, decimals)
                detail.balance = generalbalance
                detail.save()

                expectedinterest = 0
                # while date1 < date2:
                while m <= duration:
                    sfine = 0
                    sfines = 0
                    if m == nextschedule or (
                            m == duration and paidschedules == duration
                    ):
                        isnext = 1

                        spaid = round(nextbal, decimals)
                        sbalance = round(nextintallment, decimals)

                    elif m < nextschedule:
                        isnext = 0
                        spaid = round(payable, decimals)
                        sbalance = 0

                    else:
                        isnext = 2
                        spaid = 0
                        sbalance = round(payable, decimals)

                    days.append(date1.strftime("%Y-%m-%d"))

                    # print(nowdate)
                    # print(date1)
                    if date1 < nowdate and isnext > 0:
                        for loanfine in loanfines:
                            fineamount = loanfine.general_charge.amount
                            if loanfine.general_charge.is_percentage == True:
                                sfines = (fineamount / 100) * payable
                            else:
                                sfines = fineamount

                            sfine = float(sfine) + float(sfines)
                    else:
                        sfine = 0

                    sfine = round(sfine, decimals)
                    print(sfine)

                    interestperschedue = rbalance * interest
                    interestperschedue = interestperschedue

                    expectedinterest = expectedinterest + interestperschedue
                    if interest > 0:
                        rbalance = principal * (
                                (pow((1 + interest), duration) - pow((1 + interest), m))
                                / (pow((1 + interest), duration) - 1)
                        )
                    else:
                        rbalance = rbalance - payable
                    if intpaid == m or intpaid > m:
                        actualinterest = 0

                    else:
                        actualinterest = interestperschedue

                    rprincipal = payable - interestperschedue
                    rprincipal = rprincipal

                    rbalance = rbalance

                    pbalance = pbalance - rprincipal
                    if spaid > 0:
                        cumrative_payments = cumrative_payments + spaid

                    else:
                        cumrative_payments = 0

                    loan_dict[in_date] = date1.strftime("%Y-%m-%d")
                    loan_dict[rprincipal] = rprincipal
                    loan_dict[rbalance] = rbalance
                    loan_dict[isnext] = isnext
                    loan_dict[interestperschedue] = interestperschedue
                    loan_dict[spaid] = spaid
                    loan_dict[sbalance] = sbalance
                    loan_dict[actualinterest] = actualinterest
                    data.append(
                        [
                            round(rprincipal, decimals),
                            loan_dict[in_date],
                            round(rbalance, decimals),
                            round(interestperschedue, decimals),
                            round(isnext, decimals),
                            round(spaid, decimals),
                            round(sbalance, decimals),
                            round(actualinterest, decimals),
                            sfine,
                            round(payable, decimals),
                            round(pbalance, decimals),
                            round(cumrative_payments, decimals),
                        ]
                    )
                    date1 = sch_date + m * to_add
                    m = m + 1
                    sfine = 0

                    # date1 = date1 + to_add

                    # //principal = rprincipal

            if detail.sub_intervals == True:
                totalinterest = round(totalinterest, decimals)
                totalpayable = approved_amount + totalinterest
            else:
                totalinterest = round(totalpayable - principal, decimals)

            generalbalance = (totalpayable - paidamount)
            
            try:
                if generalbalance == 0 or generalbalance < 1:
                    generalbalance = 0
                    detail.loan_status = 4

            except:
                pass
            generalbalance = round(generalbalance, decimals)
            detail.balance = generalbalance
            detail.save()

            #
            totalpayable = round(totalpayable, decimals)

        nowdate = datetime.today()
    

    # determine if to show the close loan manually
    # if principal is paid off completely, status is disbursed
    # real_loan_details = Loans.objects.get(id=pk)
    this_loan_fines = LoanFines.objects.filter(loan_id=loanid)
    query_fines = this_loan_fines.aggregate(Sum("amount"))
    total_fines = query_fines["amount__sum"] or 0
    # print('total_fines', total_fines)
    query_fines_paid = LoanFinePayments.objects.filter(loan_id=loanid).aggregate(
        Sum("amount")
    )
    total_fine_paid = query_fines_paid["amount__sum"] or 0
    # print('total_fine_paid', total_fine_paid)
    unpaid_fines = total_fines - total_fine_paid

    # generalbalance

    # percent_unpaid
    try:
        # print("GENERAL BAL B4 any", generalbalance)
        generalbalance = generalbalance + unpaid_fines
        percent_paid = paidamount / (totalpayable + unpaid_fines) * 100
        percent_unpaid = generalbalance / (totalpayable + unpaid_fines) * 100

        percent_paid = round(percent_paid, 2)
        percent_unpaid = round(percent_unpaid, 2)

    except:
        percent_paid = 0
        percent_unpaid = 0

    # print('########### ------------ BALANCE ---------------------- #####################')
    # print('generalbalance',generalbalance)

def get_business_loans_context_data(request):
    business_context = session_business_data(request)
    data_context = determine_business_id_list(request.user.staff, business_context)

    the_current_branch_name = ''
    the_branch = None
    if business_context is None:
        the_current_branch_name = 'all branches'
    else:
        # get the current branch
        the_branch = Branch.objects.filter(business=business_context).first()
        the_current_branch_name = the_branch.name


    the_filter_branch = ''
    business_filter = ''

    if business_context is None:
        business_filter = request.GET.get('business_filter', '')
        if business_filter:
            if business_filter != 'all_branches':
                # get the branch
                the_filter_branch = Branch.objects.filter(business_id=business_filter).first().name
                # update the data context businesses
                data_context['all_ids'] = [business_filter]
            else:
                the_filter_branch = 'all branches'

    # if data_context['title'] == 'all branches':
    #     title = 'Groups for all branches'
    # else:
    #     title = f'Groups for {the_current_branch_name}'

    return {
        'data_context': data_context['all_ids'],
        'the_current_branch_name': the_current_branch_name,
        'business_filter':business_filter,
        'branch': the_branch
    }

    



    





