import calendar
import datetime
import re

from django.db.models import Sum

from accounts.models import Branch
from loans.models import Loans, LoanTypes, IntervalChoices, UploadLoans, ApplicationAccountOrLoanType, LoanCharges, \
    LoanTopups
from loans.utils.amortisation import loan_payment_details
from loans.utils.loan_number_creation import get_new_loan_number
from transactions.models import Account, Transactions, AccountCategory
import datetime
from pandas import Timestamp

def get_bounced_loans_submitted_values(request):
    return{
        'upload_file': request.FILES['upload_file'],
        'narration':request.POST['narration'],
    }

def check_bounced_loans_fields_xlsx(data):
    fields = ['loan number', 'date']
    fields_missing = []
    for field in fields:
        if not field in data:
            fields_missing.append(field)
    return fields_missing

def reverse_transactions_and_close_loan(business_data, branch_data, excel_data, values_submitted):
    loan = Loans.objects.filter(loan_number=excel_data['loan number'])
    if loan.exists():
        loan = loan.first()
    else:
        return{
            'status': 'failed',
            'reason': 'Loan does not exist'
        }

    receivable_acc = Account.objects.filter(name='Loan Receivables', business=business_data).first()
    loan_debits = Transactions.objects.filter(
        loan=loan,
        transaction_type='Loan repayment'
    )
    # print('COUNT AND STATUS', loan_debits.count(), loan.loan_status)
    if loan_debits.count() == 0 and int(loan.loan_status) == 3:
        timestamp = Timestamp(excel_data['date'])
        formatted_string = timestamp.strftime('%Y-%m-%d')
        excel_date = datetime.datetime.strptime(formatted_string, '%Y-%m-%d').date()

        # Reverse transaction
        give_loan_trans = Transactions.objects.filter(
            transaction_type='give loan',
            loan = loan
        )
        if give_loan_trans.exists():
            give_loan_trans = give_loan_trans.first()
            Transactions.objects.create(
                account_cr=give_loan_trans.account_dr,
                account_dr=give_loan_trans.account_cr,
                loan=loan,
                transaction_type='Reverse transaction',
                narration=values_submitted['narration'],
                tx_date= excel_date,
                branch=branch_data,
                reporting_amount=give_loan_trans.reporting_amount
            )
            Loans.objects.filter(id=loan.id).update(
                loan_status=4
            )
        return {
            'status': 'success',
            'transaction': give_loan_trans.id
        }

    else:
        return {
            'status': 'failed',
            'reason': 'Loan is either not disbursed status or Payments have already been made on this loan'
        }
