import calendar
from abc import ABC, abstractmethod
import datetime

from dateutil.relativedelta import relativedelta

from loans.models import IntervalChoices


def last_day_of_month(year, month):
    return calendar.monthrange(year, month)[1]

class EndDate(ABC):
    @abstractmethod
    def gen_end_date(self, schedule: int):
        pass


class Daily(EndDate):
    def __init__(self, start_date):
        self.start_date = start_date

    def gen_end_date(self, schedule):

        payment_date = self.start_date + datetime.timedelta(days=schedule) if self.start_date else None
        return payment_date


class Weekly(EndDate):
    def __init__(self, start_date):
        self.start_date = start_date

    def gen_end_date(self, schedule):
        payment_date = self.start_date + datetime.timedelta(weeks=schedule)
        return payment_date


class Fortnite(EndDate):
    def __init__(self, start_date):
        self.start_date = start_date

    def gen_end_date(self, schedule):
        de_schedule = schedule/2
        payment_date = self.start_date + relativedelta(weeks=int(de_schedule))
        return payment_date


class Monthly(EndDate):
    def __init__(self, start_date):
        self.start_date = start_date

    def gen_end_date(self, schedule):
        payment_date = self.start_date + relativedelta(months=schedule)

        return payment_date


class Annually(EndDate):
    def __init__(self, start_date):
        self.start_date = start_date

    def gen_end_date(self, schedule):
        payment_date = self.start_date + relativedelta(years=schedule)

        return payment_date


def find_end_date(option, *args, **kwargs) -> EndDate:
    if option == IntervalChoices.DAYS:
        return Daily(*args, **kwargs)

    elif option == IntervalChoices.WEEKS:
        return Weekly(*args, **kwargs)

    elif option == IntervalChoices.FORTNIGHT:
        return Fortnite(*args, **kwargs)

    elif option == IntervalChoices.MONTHS:
        return Monthly(*args, **kwargs)

    elif option == IntervalChoices.YEARS:
        return Annually(*args, **kwargs)
    else:
        raise ValueError("Invalid Option")
