#!/usr/bin/env python

import asyncio
import json
import socket
from contextlib import closing

import websockets


async def handler(websocket):
    while True:
        try:
            message = await websocket.recv()
            # print(message)
        except websockets.ConnectionClosedOK:
            break
        print('me', message)
        event = {"message":"oppo","username":"opiookello"}
        await websocket.send(json.dumps(event))

def check_socket(host, port):
    with closing(socket.socket(socket.AF_INET, socket.SOCK_STREAM)) as sock:
        if sock.connect_ex((host, port)) == 0:
            print("Port is open")
            return True
        else:
            print("Port is not open")
            return False

async def main_site(*args, **kwargs):
    # host = kwargs['host']
    # print(host)
    if not check_socket('localhost', 8001):
        async with websockets.serve(handler, 'localhost', 8001):
            await asyncio.Future()  # run forever
    else:
        pass


# if __name__ == "__main__":
#     asyncio.run(main_site())
