from django.urls import path
from loans.new_views import core, products, application
from loans.new_views import payments
from loans.new_views import uploads
from loans.new_views.test_view import one

urlpatterns = [
    path('settings/', core.LoanSettingsView.as_view(), name='new_loans_settings'),
    path('loan-applications/', core.AppliedLoansView.as_view(), name='new_applied_loans'),
    path('apply-loan/', application.ApplyLoanView.as_view(), name='new_apply_loan'),
    path('loan-details/<int:pk>/', application.LoanDetailView.as_view(), name='new_loan_details'),
    path('loan-edit/<int:pk>/', application.EditLoanView.as_view(), name='edit_loan'),
    path('disburse/<int:pk>/', application.DisburseLoanView.as_view(), name='disburse_loan'),
    path('loan-types/', products.LoanTypesView.as_view(), name='loan_types_new'),
    path('loan-types-edit/<int:pk>/', products.LoanTypesEditView.as_view(), name='loan_types_edit_new'),
    path('loan-types-delete/<int:pk>/', products.LoanTypesDeleteView.as_view(), name='loan_types_delete_new'),
    path('loan-schedule/<int:pk>/', application.LoanScheduleView.as_view(), name='loan_schedule'),
    path('payment-history/<int:pk>/', application.PaymentHistoryView.as_view(), name='loan_payment_history'),
    path('loan-payment-security/<int:pk>/', application.SecurityView.as_view(), name='loan_security'),
    path('loan-guarantors/<int:pk>/', application.GuarantorsView.as_view(), name='loan_guarantor'),
    path('add-guarantors/<int:pk>/', application.AddGuarantorView.as_view(), name='add_guarantor'),
    path('delete-guarantors/<int:pk>/<int:pk2>/', application.DeleteGuarantorView.as_view(), name='delete_guarantor'),
    path('committee-action/<int:pk>/', application.CommitteeActionView.as_view(), name='loan_committee_action'),
    path('submit-approval/<int:pk>/', application.SubmitApproval.as_view(), name='loan_submit_approval'),
    path('delete-adjustment/<int:pk>/', application.DeleteAdjustmentView.as_view(), name='delete_adjustment'),
    path('add-security/<int:pk>/', application.AddSecurityView.as_view(), name='add_security'),
    path('edit-security/<int:pk>/<int:pk2>/', application.EditSecurityView.as_view(), name='edit_security'),
    path('delete-security/<int:pk>/<int:pk2>/', application.DeleteSecurityView.as_view(), name='delete_security'),
    path('add-document/<int:pk>/', application.AddLoanDocumentView.as_view(), name='add_document'),
    path('edit-document/<int:pk>/<int:pk2>/', application.EditDocumentView.as_view(), name='edit_document'),
    path('delete-document/<int:pk>/<int:pk2>/', application.DeleteDocument.as_view(), name='delete_document'),
    path('running-loans/', core.RunningLoans.as_view(), name='new_running_loans'),
    path('cleared-loans/', core.ClearedLoans.as_view(), name='new_cleared_loans'),
    path('loan-topups/', core.TopupReport.as_view(), name='new_loan_topups'),
    path('repayment/<int:pk>/', payments.RepayLoanView.as_view(), name='repay_loan'),
    path('getdetails/<int:pk>/', application.Getdetail.as_view(), name='new_get_detail'),
    path('delete-repayment/<int:pk>/<str:receipt>/', payments.DeleteRepaymentView.as_view(), name='delete_repayment'),
    path('loan-uploads/', uploads.LoanUploadsView.as_view(), name='new_loan_uploads'),
    path('upload-repayments/', uploads.UploadRepyments.as_view(), name='new_upload_repayment'),
    path('upload-form-repayments/', uploads.UploadRepaymentFormView.as_view(), name='upload_form_repayment'),
    path('web-test/<str:room_name>/', one, name='one'),

]
