import pandas as pd
from django import forms
from django.core.exceptions import ValidationError

from loans.models import Loans
from loans.utils.loan_uploads_utils import trim_lower_case_dictionary_keys
from sacco.models import AccountBroker
from sacco.utils import businessdata, userdata, check_old_repayment_template, \
    branchdata, is_excel_doc
from transactions.models import Account, AccountCategory
from django.utils.translation import gettext as _


class LoanUploadForm(forms.Form):
    proof = forms.FileField()
    udate = forms.DateField()
    loantype = forms.IntegerField()
    credited = forms.CharField()
    narration = forms.CharField()
    lstatus = forms.CharField()
    rate_type = forms.CharField()

    def clean(self):
        pass

    def submit(self, commit=True):
        return


class RepaymentUploadForm(forms.Form):
    error_messages = {
        'missing_fields': _('Some fields are missing'),
    }
    debited = forms.CharField()
    proof = forms.FileField()
    udate = forms.DateField()
    narration = forms.CharField()

    def __init__(self, *args, **kwargs):
        self.request = kwargs.pop('request', None)
        super(RepaymentUploadForm, self).__init__(*args, **kwargs)

    def clean_proof(self):
        cleaned_data = self.cleaned_data
        file = cleaned_data['proof']
        # print('my', file)
        to_dict = self.iterate_excel(file)
        # print(to_dict)
        fields_missing = check_old_repayment_template(trim_lower_case_dictionary_keys(to_dict[0]))
        if len(fields_missing) > 0:
            raise ValidationError(self.error_messages['missing_fields'], code='missing_fields')
        print(to_dict)
        return to_dict

    def iterate_excel(self, file):
        if is_excel_doc(file):
            df = pd.read_excel(file, dtype={"order": str}, engine='openpyxl')
        else:
            df = pd.read_csv(file)
        df.fillna('', inplace=True)
        df.columns.astype(str)
        df.columns = df.columns.str.strip()
        return df.to_dict('records')

    def save(self):
        cleaned_data = self.cleaned_data
        file = cleaned_data['proof']
        business = businessdata(self.request)
        branch = branchdata(self.request)
        credited = Account.objects.filter(name='Loan Receivables', business=business).first()
        interest_receivable = Account.objects.filter(name='Loan interest receivables', business=business)
        if not interest_receivable.exists():
            categeory = AccountCategory.objects.filter(name='Account Receivables', business=business).first()
            interest_receivable = Account.objects.create(name='Loan interest receivables',
                                                 business_id=business,
                                                 category_id=categeory.id,
                                                 added_by_id=userdata(self.request))
        for i, upload in enumerate(file):
            account_number = str(upload['ACCOUNT NUMBER']).strip()
            deposit_date = str(upload['DEPOSIT DATE']).strip()
            amount = str(upload['AMOUNT']).strip()
            ref = str(upload['REFERENCE']).strip()
            member = AccountBroker.objects.filter(the_account__acc_number=account_number,
                                                  business_id=business).first()
            if member is not None:
                loan = Loans.objects.filter(account_id=member.the_account_id, loan_status=3, branch_id=branch).order_by(
                    'schedule_start').first()
                print(loan)
            print('me not exist')

        return cleaned_data
