import datetime
import uuid

from django import forms
from django.core.exceptions import ValidationError
from django.db import transaction
from django.db.models import Q, Sum, FloatField
from django.db.models.functions import Coalesce
from django.utils.translation import gettext as _

from sacco.utils import biz_staff, biz_data, branch_id
from transactions.models import Account, Transactions, AccountCategory


class RepayLoanForm(forms.Form):
    error_messages = {
        'applicant_balance': _('The applicant balance is insufficient'),
    }
    amount = forms.CharField()
    d_date = forms.DateField()
    debited = forms.CharField(required=False)
    fineamount = forms.CharField(required=False)
    interestamount = forms.CharField(required=False)
    principalamount = forms.CharField(required=False)
    principalbalance = forms.CharField(required=False)
    narration = forms.CharField(required=False)
    reference = forms.CharField(required=False)

    def __init__(self, *args, **kwargs):
        self.loan = kwargs.pop('loan', None)
        self.user = kwargs.pop('user', None)
        super(RepayLoanForm, self).__init__(*args, **kwargs)

    def clean_amount(self):
        cleaned_data = self.cleaned_data
        amount = cleaned_data['amount']
        cleaned_amount = float(amount.replace(',', ''))

        return cleaned_amount

    def clean_fineamount(self):
        cleaned_data = self.cleaned_data
        amount = cleaned_data.get('fineamount')
        if amount:
            cleaned_amount = float(amount.replace(',', ''))
            return cleaned_amount
        return 0

    def clean_interestamount(self):
        amount = self.cleaned_data['interestamount']
        cleaned_amount = float(amount.replace(',', ''))
        return cleaned_amount

    def clean_principalamount(self):
        amount = self.cleaned_data['principalamount']
        cleaned_amount = float(amount.replace(',', ''))
        return cleaned_amount

    def clean_principalbalance(self):
        amount = self.cleaned_data['principalbalance']
        amount = amount.replace(',', '')
        print('me', amount)
        cleaned_amount = float(amount)
        return cleaned_amount


    def clean_reference(self):
        receipt = self.cleaned_data.get('reference', None)
        if not receipt:
            receipt = datetime.datetime.now().strftime("%y%m%d%H%M%S")
        return receipt

    # def clean(self):
    #     cleaned_data = self.cleaned_data
    #     loan = self.loan
    #     # applicant_account = loan.account.account.all().first()
    #     applicant_balance = loan.account.balance
    #     debited_account = cleaned_data['debited']
    #     amount = cleaned_data['amount']
    #     if debited_account == 'm':
    #         if applicant_balance < amount:
    #             raise ValidationError(
    #                 self.error_messages['applicant_balance'],
    #                 code='applicant_balance',
    #             )


class DeleteRepaymentForm(forms.Form):
    csrfmiddlewaretoken = forms.CharField()
    tdate = forms.CharField()
    amount = forms.CharField()
    reason = forms.CharField()
