from django.urls import path

from client_custom.namayingo.views import DeleteGroupMember, GroupMembers, BulkDeposit, CreateGroupView, \
    UploadMemberData, UploadsWaitingView, UploadsWaitingDetailView, ApproveUploadView, UpdateFileView, DeleteGroupView, \
    ReverseUploadedData, DownloadExcelFailedUploadData, AllGroupsUploadMemberData

urlpatterns = [
    path('group/<int:pk>/delete-member/<int:pk1>/', DeleteGroupMember.as_view(), name='namayingo_delete_group_member'),
    path('group/<int:pk>/members/', GroupMembers.as_view(), name='namayingo_group_members'),
    path('group-bulk-deposit/<int:pk>/', BulkDeposit.as_view(), name='namayingo_make_bulk_deposit'),
    path('group-member-data/<int:pk>/', UploadMemberData.as_view(), name='namayingo_upload_data'),
    path('create-group/', CreateGroupView.as_view(), name='namayingo_create_group'),
    path('waiting-approvals/', UploadsWaitingView.as_view(), name='waiting_approvals'),
    path('uploads-preview/<int:pk>/', UploadsWaitingDetailView.as_view(), name='uploads_preview'),
    path('approve-upload/<int:pk>/', ApproveUploadView.as_view(), name='approve_upload'),
    path('update-file/<int:pk>/', UpdateFileView.as_view(), name='update_file'),
    path('delete-the-group/<int:pk>/', DeleteGroupView.as_view(), name='delete_the_group_final'),
    path('reverse-group-upload/<int:pk>/', ReverseUploadedData.as_view(), name='reverse_group_upload'),
    path('download-failed-group-uploads/<int:pk>/', DownloadExcelFailedUploadData.as_view(), name='download_failed_group_uploads'),
    path('all-groups-members-data/', AllGroupsUploadMemberData.as_view(), name='all_groups_members_data'),
]
