import uuid

from django.db import models

from accounts.models import Business
from transactions.models import Account


class UploadedMemberExcel(models.Model):
    PENDING = 'PENDING'
    APPROVED = 'APPROVED'
    REJECTED = 'REJECTED'

    STATUS = (
        (PENDING, 'Pending'),
        (APPROVED, 'Approved'),
        (REJECTED, 'Rejected'),

    )
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    payment_account = models.ForeignKey(Account, null=True, blank=True, on_delete=models.CASCADE)
    member_account = models.CharField(max_length=1, blank=True, null=True)
    external_id = models.UUIDField()
    status = models.CharField(max_length=20, choices=STATUS, default='PENDING')
    file = models.FileField(upload_to='group_payments')
    uploaded_by = models.ForeignKey('accounts.Staff', null=True, blank=True, on_delete=models.SET_NULL)
    business = models.ForeignKey(Business, on_delete=models.CASCADE, blank=True, null=True)
    group = models.ForeignKey('sacco.Member', null=True, blank=True, on_delete=models.SET_NULL)
    failed_records = models.TextField(blank=True, null=True)
    failed_number = models.IntegerField(blank=True, null=True, default=0)
    added_transactions = models.TextField(blank=True, null=True)
    added_loan_fines = models.TextField(blank=True, null=True)
    added_loan_fines_payments = models.TextField(blank=True, null=True)
    added_shares = models.TextField(blank=True, null=True)
    transactions_date = models.DateField(null=True, blank=True)

    def __str__(self):
        return f'{self.external_id} -> {self.created_at}'

    def save(self, *args, **kwargs):
        if not self.id:
            value = uuid.uuid4().hex
            self.external_id = str(value)
        return super(UploadedMemberExcel, self).save(*args, **kwargs)

    @property
    def file_url(self):
        if self.file and hasattr(self.file, 'url'):
            return self.file.url


class ExcelApproval(models.Model):
    admin = models.ForeignKey('accounts.Staff', on_delete=models.CASCADE)
    upload = models.ForeignKey(UploadedMemberExcel, related_name='approvals', on_delete=models.CASCADE)


class RequiredUploadApprovals(models.Model):
    number = models.IntegerField()
    business = models.OneToOneField(Business, unique=True, on_delete=models.CASCADE, blank=True, null=True)

    def __str__(self):
        return str(self.number)


